/*
 * Decompiled with CFR 0.152.
 */
package com.opensooq.pluto.base;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.opensooq.pluto.base.PlutoViewHolder;
import com.opensooq.pluto.listeners.OnItemClickListener;
import java.util.List;

public abstract class PlutoAdapter<T, VH extends PlutoViewHolder<T>>
extends RecyclerView.Adapter<VH> {
    private List<T> items;
    public static final int MULTIPLY = 400;
    private OnItemClickListener<T> mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener<T> onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public PlutoAdapter(List<T> items, OnItemClickListener<T> onItemClickListener) {
        this.items = items;
        this.mOnItemClickListener = onItemClickListener;
    }

    public PlutoAdapter(List<T> items) {
        this.items = items;
    }

    protected T getItem(int realPosition) {
        return this.items.get(realPosition % this.getRealCount());
    }

    public List<T> getList() {
        return this.items;
    }

    public int getItemCount() {
        return this.items == null ? 0 : (this.items.size() == 1 ? 1 : Integer.MAX_VALUE);
    }

    public int getRealCount() {
        return this.items == null ? 0 : this.items.size();
    }

    public void removeAllItems() {
        this.items.clear();
        this.notifyDataSetChanged();
    }

    public void addItem(T item) {
        this.items.add(item);
        this.notifyItemInserted(this.items.size() - 1);
    }

    public void removeItemAt(int position) {
        this.items.remove(position);
        this.notifyItemRemoved(position);
    }

    public abstract VH getViewHolder(ViewGroup var1, int var2);

    @NonNull
    public VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        VH viewHolder = this.getViewHolder(parent, viewType);
        ((PlutoViewHolder)((Object)viewHolder)).setRealAdapterCount(this.getRealCount());
        ((PlutoViewHolder)((Object)viewHolder)).setOnItemClickListener(this.mOnItemClickListener);
        return viewHolder;
    }

    public final void onBindViewHolder(@NonNull VH holder, int position) {
        ((PlutoViewHolder)((Object)holder)).mPosition = position %= this.getRealCount();
        ((PlutoViewHolder)((Object)holder)).setRealAdapterCount(this.getRealCount());
        ((PlutoViewHolder)((Object)holder)).setTag(this.items.get(position));
        ((PlutoViewHolder)((Object)holder)).set(this.items.get(position), position);
    }
}

