/*
 * Decompiled with CFR 0.152.
 */
package com.opensooq.pluto;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.PagerSnapHelper;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SnapHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.opensooq.pluto.PlutoIndicator;
import com.opensooq.pluto.R;
import com.opensooq.pluto.base.PlutoAdapter;
import com.opensooq.pluto.listeners.OnSlideChangeListener;
import com.opensooq.pluto.listeners.SnapOnScrollListener;
import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;

public class PlutoView
extends FrameLayout {
    private RecyclerView rvSlider;
    private OnSlideChangeListener mOnSlideChangeListener;
    private PlutoAdapter mAdapter;
    private long duration = 4000L;
    private int currentPosition;
    private PlutoIndicator mIndicator;
    private boolean mIndicatorVisibility;
    private Timer mCycleTimer;
    private TimerTask mCycleTask;
    private Timer mResumingTimer;
    private boolean mCycling;
    private boolean mAutoRecover = true;
    private boolean mAutoCycle;
    private SnapHelper helper;
    private RecyclerView.OnScrollListener mOnScrollListener;
    private TimerTask mResumingTask;
    private Handler mh = new IncomingHandler(this);

    public PlutoView(@NonNull Context context) {
        this(context, null);
    }

    public PlutoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.PlutoViewStyle);
    }

    public PlutoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        PlutoView.inflate((Context)this.getContext(), (int)R.layout.layout_view_slider, (ViewGroup)this);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PlutoView, defStyleAttr, 0);
        this.rvSlider = (RecyclerView)this.findViewById(R.id.rvSlider);
        this.mAutoCycle = attributes.getBoolean(R.styleable.PlutoView_auto_cycle, true);
        this.mIndicatorVisibility = attributes.getBoolean(R.styleable.PlutoView_indicator_visibility, false);
        this.initScrollListener();
        this.rvSlider.addOnItemTouchListener(new RecyclerView.OnItemTouchListener(){

            public boolean onInterceptTouchEvent(@NonNull RecyclerView recyclerView, @NonNull MotionEvent motionEvent) {
                int action = motionEvent.getAction();
                if (action == 1) {
                    PlutoView.this.recoverCycle();
                }
                return false;
            }

            public void onTouchEvent(@NonNull RecyclerView recyclerView, @NonNull MotionEvent motionEvent) {
            }

            public void onRequestDisallowInterceptTouchEvent(boolean b) {
            }
        });
        attributes.recycle();
        this.setIndicatorVisibility(this.mIndicatorVisibility);
        if (this.mAutoCycle) {
            this.startAutoCycle();
        }
    }

    private void initScrollListener() {
        this.mOnScrollListener = null;
        this.mOnScrollListener = new SnapOnScrollListener(this.helper, position -> {
            this.currentPosition = position;
            if (this.mOnSlideChangeListener != null) {
                this.mOnSlideChangeListener.onSlideChange(this.getAdapter(), position % this.getAdapter().getRealCount());
            }
        });
    }

    public void create(PlutoAdapter adapter, long duration) {
        this.setAdapter(adapter);
        if (duration != -1L) {
            this.duration = duration;
        }
        this.setIndicatorPosition(IndicatorPosition.CENTER_BOTTOM);
    }

    public void create(PlutoAdapter adapter) {
        this.create(adapter, -1L);
    }

    public void setIndicatorVisibility(boolean visibility) {
        if (this.mIndicator == null) {
            return;
        }
        this.mIndicator.setVisibility(visibility);
    }

    public boolean getIndicatorVisibility() {
        if (this.mIndicator != null) {
            return this.mIndicator.isVisible();
        }
        return false;
    }

    public void setIndicatorPosition(IndicatorPosition presetIndicator) {
        PlutoIndicator PlutoIndicator2 = (PlutoIndicator)this.findViewById(presetIndicator.getResourceId());
        this.setCustomIndicator(PlutoIndicator2);
    }

    public void setCustomIndicator(PlutoIndicator indicator) {
        if (this.mIndicator != null) {
            this.mIndicator.destroySelf();
        }
        this.mIndicator = indicator;
        this.mIndicator.setVisibility(this.mIndicatorVisibility);
        this.mIndicator.setRecyclerView(this.rvSlider, this.helper);
        this.mIndicator.redraw();
    }

    private void setAdapter(PlutoAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("custom Adapter cannot be null");
        }
        this.mAdapter = adapter;
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.getContext(), 0, false);
        linearLayoutManager.setInitialPrefetchItemCount(4);
        this.rvSlider.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.rvSlider.setAdapter((RecyclerView.Adapter)adapter);
        this.addScrollListener();
        this.setCurrentPosition(0, false);
    }

    private void addScrollListener() {
        this.helper = new PagerSnapHelper();
        this.rvSlider.setOnFlingListener(null);
        this.helper.attachToRecyclerView(this.rvSlider);
        if (this.mOnScrollListener != null) {
            this.rvSlider.removeOnScrollListener(this.mOnScrollListener);
        }
        this.initScrollListener();
        this.rvSlider.addOnScrollListener(this.mOnScrollListener);
    }

    private PlutoAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setOnSlideChangeListener(OnSlideChangeListener onSlideChangeListener) {
        this.mOnSlideChangeListener = onSlideChangeListener;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getCurrentPosition() {
        if (this.getAdapter() == null) {
            throw new IllegalStateException("You did not set a slider adapter");
        }
        return this.currentPosition % this.getAdapter().getRealCount();
    }

    public void removeSliderAt(int position) {
        if (position >= this.getAdapter().getRealCount() || position < 0) {
            throw new IndexOutOfBoundsException("trying to access position" + position + " where size" + this.getAdapter().getRealCount());
        }
        if (this.getAdapter() != null) {
            this.getAdapter().removeItemAt(position);
        }
    }

    public void removeAllSliders() {
        if (this.getAdapter() != null) {
            this.getAdapter().removeAllItems();
        }
    }

    public void setCurrentPosition(int position, boolean smooth) {
        if (this.getAdapter() == null) {
            this.onDestroy();
        }
        if (position >= this.getAdapter().getRealCount() || position < 0) {
            throw new IndexOutOfBoundsException("trying to access position" + position + " where size" + this.getAdapter().getRealCount());
        }
        this.currentPosition = this.getAdapter().getRealCount() * 400 + position;
        if (smooth) {
            this.rvSlider.smoothScrollToPosition(this.currentPosition);
        } else {
            this.rvSlider.scrollToPosition(this.currentPosition);
        }
    }

    public void setCurrentPosition(int position) {
        this.setCurrentPosition(position, true);
    }

    public void movePrevPosition(boolean smooth) {
        --this.currentPosition;
        if (this.getAdapter() == null) {
            this.onDestroy();
        }
        if (smooth) {
            this.rvSlider.smoothScrollToPosition(this.currentPosition);
        } else {
            this.rvSlider.scrollToPosition(this.currentPosition);
        }
    }

    public void movePrevPosition() {
        this.movePrevPosition(true);
    }

    public void moveNextPosition(boolean smooth) {
        ++this.currentPosition;
        if (this.getAdapter() == null) {
            this.onDestroy();
        }
        if (smooth) {
            this.rvSlider.smoothScrollToPosition(this.currentPosition);
        } else {
            this.rvSlider.scrollToPosition(this.currentPosition);
        }
    }

    public void moveNextPosition() {
        this.moveNextPosition(true);
    }

    public void startAutoCycle() {
        this.startAutoCycle(this.duration, this.duration, this.mAutoRecover);
    }

    public void startAutoCycle(long delay, long duration, boolean autoRecover) {
        if (this.mCycleTimer != null) {
            this.mCycleTimer.cancel();
        }
        if (this.mCycleTask != null) {
            this.mCycleTask.cancel();
        }
        if (this.mResumingTask != null) {
            this.mResumingTask.cancel();
        }
        if (this.mResumingTimer != null) {
            this.mResumingTimer.cancel();
        }
        this.duration = duration;
        this.mCycleTimer = new Timer();
        this.mAutoRecover = autoRecover;
        this.mCycleTask = new TimerTask(){

            @Override
            public void run() {
                PlutoView.this.mh.sendEmptyMessage(0);
            }
        };
        this.mCycleTimer.schedule(this.mCycleTask, delay, duration);
        this.mCycling = true;
        this.mAutoCycle = true;
    }

    private void pauseAutoCycle() {
        if (this.mCycleTask == null) {
            this.onDestroy();
            return;
        }
        if (this.mCycling) {
            this.mCycleTimer.cancel();
            this.mCycleTask.cancel();
            this.mCycling = false;
        } else if (this.mResumingTimer != null && this.mResumingTask != null) {
            this.recoverCycle();
        }
    }

    private void recoverCycle() {
        if (!this.mAutoRecover || !this.mAutoCycle) {
            return;
        }
        if (!this.mCycling) {
            if (this.mResumingTask != null && this.mResumingTimer != null) {
                this.mResumingTimer.cancel();
                this.mResumingTask.cancel();
            }
            this.mResumingTimer = new Timer();
            this.mResumingTask = new TimerTask(){

                @Override
                public void run() {
                    PlutoView.this.startAutoCycle();
                }
            };
            this.mResumingTimer.schedule(this.mResumingTask, 6000L);
        }
    }

    public void setDuration(long duration) {
        if (duration >= 500L) {
            this.duration = duration;
            if (this.mAutoCycle && this.mCycling) {
                this.startAutoCycle();
            }
        }
    }

    public void stopAutoCycle() {
        if (this.mCycleTask != null) {
            this.mCycleTask.cancel();
        }
        if (this.mCycleTimer != null) {
            this.mCycleTimer.cancel();
        }
        if (this.mResumingTimer != null) {
            this.mResumingTimer.cancel();
        }
        if (this.mResumingTask != null) {
            this.mResumingTask.cancel();
        }
        this.mAutoCycle = false;
        this.mCycling = false;
        this.onDestroy();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 0) {
            this.pauseAutoCycle();
        }
        return false;
    }

    public boolean isAutoCycling() {
        return this.mCycling;
    }

    public void onDetachedFromWindow() {
        this.onDestroy();
        super.onDetachedFromWindow();
    }

    private void onDestroy() {
        if (this.mCycleTimer != null) {
            this.mCycleTimer.cancel();
        }
        if (this.mCycleTask != null) {
            this.mCycleTask.cancel();
        }
        if (this.mResumingTask != null) {
            this.mResumingTask.cancel();
        }
        if (this.mResumingTimer != null) {
            this.mResumingTimer.cancel();
        }
        if (this.mh != null) {
            this.mh.removeCallbacksAndMessages(null);
        }
        if (this.mIndicator != null) {
            this.mIndicator.destroySelf();
        }
        if (this.rvSlider != null && this.mOnScrollListener != null) {
            this.rvSlider.removeOnScrollListener(this.mOnScrollListener);
        }
        this.mOnScrollListener = null;
        this.mOnSlideChangeListener = null;
        this.mCycleTimer = null;
        this.mCycleTask = null;
        this.mResumingTask = null;
        this.mResumingTimer = null;
    }

    static class IncomingHandler
    extends Handler {
        private final WeakReference<PlutoView> mSliderWeakReference;

        IncomingHandler(PlutoView plutoView) {
            this.mSliderWeakReference = new WeakReference<PlutoView>(plutoView);
        }

        public void handleMessage(Message msg) {
            PlutoView plutoView = (PlutoView)((Object)this.mSliderWeakReference.get());
            if (plutoView != null) {
                plutoView.moveNextPosition();
            }
        }
    }

    public static enum IndicatorPosition {
        CENTER_BOTTOM("CENTER_BOTTOM", R.id.default_center_bottom_indicator),
        RIGHT_BOTTOM("RIGHT_BOTTOM", R.id.default_bottom_end_indicator),
        LEFT_BOTTOM("LEFT_BOTTOM", R.id.default_bottom_start_indicator),
        CENTER_TOP("CENTER_TOP", R.id.default_center_top_indicator),
        RIGHT_TOP("RIGHT_TOP", R.id.default_center_top_end_indicator),
        LEFT_TOP("LEFT_TOP", R.id.default_center_top_start_indicator);

        private final String name;
        private final int id;

        private IndicatorPosition(String name, int id2) {
            this.name = name;
            this.id = id2;
        }

        public String toString() {
            return this.name;
        }

        public int getResourceId() {
            return this.id;
        }
    }
}

