/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.util;

import hudson.Platform;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.security.MasterToSlaveCallable;

public class FindOC
extends MasterToSlaveCallable<List<String>, Throwable> {
    private static final long serialVersionUID = 1L;
    private String path;

    public FindOC(String path) {
        this.path = path;
    }

    public List<String> call() {
        String ocFileName = Platform.current() == Platform.WINDOWS ? "oc.exe" : "oc";
        String[] dirs = this.path.split(File.pathSeparator);
        return Arrays.stream(dirs).map(dir -> new File((String)dir, ocFileName)).filter(file -> file.isFile() && file.canExecute()).map(file -> file.getAbsolutePath()).collect(Collectors.toList());
    }
}

