/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline;

import com.openshift.jenkins.plugins.util.ClientCommandBuilder;
import com.openshift.jenkins.plugins.util.ClientCommandRunner;
import groovy.json.JsonException;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.util.QuotedStringTokenizer;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class OcWatch
extends AbstractStepImpl {
    private static Logger LOGGER = Logger.getLogger(OcWatch.class.getName());
    public static final String FUNCTION_NAME = "_OcWatch";
    private final ClientCommandBuilder cmdBuilder;
    private final int watchLoglevel;

    @DataBoundConstructor
    public OcWatch(String server, String project, boolean skipTLSVerify, String caPath, String verb, List advArgs, List verbArgs, List userArgs, List options, String token, int logLevel) {
        this.watchLoglevel = logLevel;
        this.cmdBuilder = new ClientCommandBuilder(server, project, skipTLSVerify, caPath, verb, advArgs, verbArgs, userArgs, options, token, logLevel, false);
    }

    public static final class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient OcWatch step;
        @StepContextParameter
        private transient FilePath filePath;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient EnvVars envVars;
        @StepContextParameter
        private transient TaskListener listener;

        public Void run() throws IOException, InterruptedException {
            if (this.filePath != null && !this.filePath.exists()) {
                this.filePath.mkdirs();
            }
            this.getContext().saveState();
            this.listener.getLogger().println("Entering watch");
            StringBuffer stderr = new StringBuffer();
            boolean[] watchSuccess = new boolean[]{false};
            String commandString = this.step.cmdBuilder.asString(false);
            String[] command = QuotedStringTokenizer.tokenize((String)commandString);
            command = ClientCommandBuilder.fixPathInCommandArray(command, this.envVars, this.listener, this.filePath, this.launcher, this.step.watchLoglevel > 0);
            TaskListener listener = this.listener;
            int[] jsonRetries = new int[]{0};
            ClientCommandRunner runner = new ClientCommandRunner(command, this.filePath, this.envVars, line -> {
                if (this.step.watchLoglevel > 0) {
                    listener.getLogger().println("Received verbose watch output>>>");
                    listener.getLogger().println(line);
                    listener.getLogger().println("<<<");
                }
                while (true) {
                    listener.getLogger().println("Running watch closure body");
                    try {
                        Object o = this.getContext().newBodyInvoker().start().get();
                        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                            watchSuccess[0] = true;
                            listener.getLogger().println("\nwatch closure returned true; terminating watch");
                            return true;
                        }
                        listener.getLogger().println("watch closure returned " + o);
                        return false;
                    }
                    catch (JsonException ex) {
                        int n = jsonRetries[0];
                        jsonRetries[0] = n + 1;
                        if (n >= 5) {
                            throw ex;
                        }
                        listener.getLogger().println("watch closer got json formatting exception, trying again");
                        continue;
                    }
                    catch (InterruptedException tie) {
                        listener.getLogger().println("\nwatch closure interrupted (timeout?)");
                        throw tie;
                    }
                    catch (Throwable t) {
                        String exceptionMsgs = t.getMessage();
                        if (t.getCause() != null) {
                            exceptionMsgs = exceptionMsgs + "; " + t.getCause().getMessage();
                        }
                        listener.getLogger().println(String.format("\nwatch closure threw an exception: \"%s\".\n", exceptionMsgs));
                        throw new IOException(t);
                    }
                    break;
                }
            }, line -> {
                stderr.append(line).append('\n');
                listener.getLogger().println("Received error output>>>");
                listener.getLogger().println(line);
                listener.getLogger().println("<<<");
                return false;
            });
            long reWatchSleep = 250L;
            try {
                while (true) {
                    int exitStatus = runner.run(this.launcher);
                    if (!watchSuccess[0]) {
                        if (exitStatus != 0) {
                            String msg = "OpenShift Client exited with status code " + Integer.toString(exitStatus) + ", command: " + this.step.cmdBuilder.buildCommand(true) + ", stderr: " + stderr.toString().trim();
                            throw new AbortException(msg);
                        }
                        listener.getLogger().println("Checking watch output and running watch closure again in " + reWatchSleep + "ms");
                        Thread.sleep(reWatchSleep);
                        if (reWatchSleep >= 10000L) continue;
                        reWatchSleep = (long)((float)reWatchSleep * 1.2f);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                this.getContext().onFailure(e);
            }
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return OcWatch.FUNCTION_NAME;
        }

        public String getDisplayName() {
            return "Internal utility function for OpenShift DSL";
        }

        public boolean isAdvanced() {
            return true;
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }
    }
}

