/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.freestyle;

import com.openshift.jenkins.plugins.freestyle.BaseStep;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RawStep
extends BaseStep {
    private final String command;
    private final String arguments;

    @DataBoundConstructor
    public RawStep(String command, String arguments) {
        this.command = command;
        this.arguments = arguments;
    }

    public String getCommand() {
        return this.command;
    }

    public String getCommand(Map<String, String> overrides) {
        return RawStep.getOverride(this.getCommand(), overrides);
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getArguments(Map<String, String> overrides) {
        return RawStep.getOverride(this.getArguments(), overrides);
    }

    public boolean perform(final AbstractBuild build, Launcher launcher, final BuildListener listener) throws IOException, InterruptedException {
        final Map<String, String> overrides = this.consolidateEnvVars((TaskListener)listener, build, launcher);
        return RawStep.withTempInput("markup", this.getCommand(overrides), new BaseStep.WithTempInputRunnable(){

            @Override
            public boolean perform(String markupFilename) throws IOException, InterruptedException {
                return RawStep.this.standardRunOcCommand(build, (TaskListener)listener, RawStep.this.getCommand(overrides), BaseStep.toList(RawStep.this.getArguments(overrides)), BaseStep.toList(new String[0]), BaseStep.toList(new String[0]));
            }
        });
    }

    @Extension
    public static final class DescriptorImpl
    extends BaseStep.BaseStepDescriptor {
        public String getDisplayName() {
            return "OpenShift - Generic OC Invocation";
        }

        public FormValidation doCommand(@QueryParameter String command) {
            return FormValidation.validateRequired((String)command);
        }

        public FormValidation doArguments(@QueryParameter String arguments) {
            return FormValidation.validateRequired((String)arguments);
        }
    }
}

