/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.util;

import com.openshift.jenkins.plugins.OpenShift;
import com.openshift.jenkins.plugins.util.FindOC;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Platform;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;

public class ClientCommandBuilder
implements Serializable {
    private static Logger LOGGER = Logger.getLogger(ClientCommandBuilder.class.getName());
    public final String server;
    public final String project;
    public final boolean skipTLSVerify;
    public final String caPath;
    public final String verb;
    public final List advArgs;
    protected final List verbArgs;
    protected final List userArgs;
    protected final List options;
    protected final String token;
    public final int logLevel;
    public final boolean streamStdOutToConsolePrefix;

    public static OsType getOsFromPlatform() {
        if (Platform.isDarwin()) {
            return OsType.DARWIN;
        }
        if (Platform.current() == Platform.WINDOWS) {
            return OsType.WINDOWS;
        }
        if (Platform.current() == Platform.UNIX && System.getProperty("os.name").equals("z/OS")) {
            return OsType.ZOS;
        }
        return OsType.UNIX;
    }

    public static String[] fixPathInCommandArray(String[] command, EnvVars envVars, TaskListener listener, FilePath filePath, Launcher launcher, boolean verbose) throws IOException, InterruptedException, RuntimeException {
        OsType targetType = (OsType)((Object)filePath.act((Callable)new getOsType()));
        String path = (String)envVars.get((Object)"PATH");
        List foundOcs = new ArrayList();
        FindOC finder = new FindOC(path);
        try {
            foundOcs = (List)filePath.act((Callable)finder);
        }
        catch (Throwable t) {
            t.printStackTrace(listener.getLogger());
            return command;
        }
        if (foundOcs == null || foundOcs.size() == 0) {
            listener.getLogger().println("could not find oc binary on the target computer of OS type " + (Object)((Object)targetType));
            if (!(launcher instanceof Launcher.RemoteLauncher) || !(launcher instanceof Launcher.LocalLauncher)) {
                listener.getLogger().println("but your launcher is of a type that might have hindered out scan");
            }
        } else if (verbose) {
            listener.getLogger().println("found the following oc executables on the target computer of OS type " + (Object)((Object)targetType) + ": " + foundOcs);
        }
        if (foundOcs.size() == 0) {
            return command;
        }
        command[0] = (String)foundOcs.get(0);
        return command;
    }

    public ClientCommandBuilder(String server, String project, boolean skipTLSVerify, String caPath, String verb, List advArgs, List verbArgs, List userArgs, List options, String token, int logLevel, boolean streamStdOutToConsolePrefix) {
        if (token != null && (token.contains("\r") || token.contains("\n"))) {
            throw new IllegalArgumentException("tokens cannot contain carriage returns or new lines");
        }
        this.server = server;
        this.project = project;
        this.skipTLSVerify = skipTLSVerify;
        this.caPath = caPath;
        this.verb = verb == null ? "help" : verb;
        this.advArgs = advArgs;
        this.verbArgs = verbArgs;
        this.userArgs = userArgs;
        this.options = options;
        this.token = token;
        this.logLevel = logLevel;
        this.streamStdOutToConsolePrefix = streamStdOutToConsolePrefix;
    }

    private String dealWithQuotes(String s) {
        if (!s.contains("'") && !s.contains("\"") || !s.startsWith("\"") && !s.startsWith("'") && s.contains("\"")) {
            s = "'" + s + "'";
        } else if (!s.startsWith("\"") && !s.startsWith("'") && s.contains("'")) {
            s = "\"" + s + "\"";
        }
        return s;
    }

    private List<String> toStringArray(List l) {
        ArrayList<String> n = new ArrayList<String>();
        if (l == null) {
            return n;
        }
        ArrayList<String> ll = new ArrayList<String>(l);
        for (int i = 0; i < ll.size(); ++i) {
            String s = (String)ll.get(i);
            if (s != null && s.trim().length() == 0) continue;
            int nextIdx = i + 1;
            if (s.trim().equals("-f") && nextIdx < ll.size() && !this.streamStdOutToConsolePrefix) {
                n.add(s);
                String f = (String)ll.get(nextIdx);
                if (f.trim().length() <= 0 || !f.trim().contains(" ")) continue;
                n.add("\"" + f + "\"");
                ll.set(nextIdx, "");
                continue;
            }
            if (this.wrapperInQuotes() && s.contains(" ")) {
                String[] params1 = s.trim().split("-p=");
                String[] params2 = s.trim().split("-p ");
                if (params1.length > 1) {
                    for (String p : params1) {
                        if (p.trim().length() <= 0) continue;
                        if (p.trim().contains(" ")) {
                            p = this.dealWithQuotes(p);
                        }
                        n.add("-p=" + p.trim());
                    }
                    continue;
                }
                if (params2.length > 1) {
                    for (String p : params2) {
                        if (p.trim().length() <= 0) continue;
                        if (p.trim().contains(" ")) {
                            p = this.dealWithQuotes(p);
                        }
                        n.add("-p " + p.trim());
                    }
                    continue;
                }
                s = this.dealWithQuotes(s);
                n.add(s);
                continue;
            }
            n.add(s);
        }
        return n;
    }

    private boolean hasArg(List<String> args, String ... argsToFind) {
        for (String arg : args) {
            for (String atf : argsToFind) {
                if (!arg.equals(atf) && !arg.startsWith(atf + "=")) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> buildCommand(boolean redacted) {
        ArrayList<String> cmd = new ArrayList<String>();
        String toolName = new OpenShift.DescriptorImpl().getClientToolName();
        cmd.add(toolName);
        if (this.server != null) {
            cmd.add("--server=" + this.server);
        }
        cmd.addAll(this.toStringArray(this.advArgs));
        if (this.skipTLSVerify) {
            cmd.add("--insecure-skip-tls-verify");
        } else if (this.caPath != null) {
            cmd.add("--certificate-authority=" + this.caPath);
        }
        if (this.project != null && !this.hasArg(cmd, "-n", "--namespace")) {
            cmd.add("--namespace=" + this.project);
        }
        if (!(redacted && this.logLevel <= 0 || this.hasArg(cmd, "--loglevel"))) {
            cmd.add("--loglevel=" + this.logLevel);
        }
        String token = this.token;
        if (redacted && token != null) {
            token = "XXXXX";
        }
        if (token != null && !this.hasArg(cmd, "--token")) {
            cmd.add("--token=" + token);
        }
        cmd.add(this.verb);
        cmd.addAll(this.toStringArray(this.verbArgs));
        cmd.addAll(this.toStringArray(this.userArgs));
        cmd.addAll(this.toStringArray(this.options));
        return cmd;
    }

    public String asString(boolean redacted) {
        StringBuffer sb = new StringBuffer();
        for (String arg : this.buildCommand(redacted)) {
            sb.append(arg);
            sb.append(" ");
        }
        return sb.toString();
    }

    public String[] asStringArray(boolean redacted) {
        List<String> list = this.buildCommand(redacted);
        return list.toArray(new String[0]);
    }

    public boolean wrapperInQuotes() {
        return this.verb.trim().equals("process");
    }

    public static final class getOsType
    extends MasterToSlaveCallable<OsType, RuntimeException> {
        private static final long serialVersionUID = 1L;

        public OsType call() throws RuntimeException {
            return ClientCommandBuilder.getOsFromPlatform();
        }
    }

    public static enum OsType {
        DARWIN,
        UNIX,
        WINDOWS,
        ZOS;

    }
}

