/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline;

import com.openshift.jenkins.plugins.util.ClientCommandBuilder;
import com.openshift.jenkins.plugins.util.ClientCommandRunner;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.QuotedStringTokenizer;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class OcAction
extends AbstractStepImpl {
    public static final Logger LOGGER = Logger.getLogger(OcAction.class.getName());
    public static final String FUNCTION_NAME = "_OcAction";
    private final ClientCommandBuilder cmdBuilder;
    private final boolean verbose;
    protected final String streamStdOutToConsolePrefix;
    private final HashMap<String, String> reference;

    @DataBoundConstructor
    public OcAction(String server, String project, boolean skipTLSVerify, String caPath, String verb, List advArgs, List verbArgs, List userArgs, List options, String token, String streamStdOutToConsolePrefix, HashMap<String, String> reference, int logLevel) {
        this.cmdBuilder = new ClientCommandBuilder(server, project, skipTLSVerify, caPath, verb, advArgs, verbArgs, userArgs, options, token, logLevel, streamStdOutToConsolePrefix != null && !streamStdOutToConsolePrefix.trim().isEmpty());
        this.verbose = logLevel > 0;
        this.streamStdOutToConsolePrefix = streamStdOutToConsolePrefix;
        this.reference = reference == null ? new HashMap() : reference;
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<OcActionResult> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient OcAction step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient EnvVars envVars;
        @StepContextParameter
        private transient Run<?, ?> runObj;
        @StepContextParameter
        private transient FilePath filePath;
        @StepContextParameter
        private transient Executor executor;
        @StepContextParameter
        private transient Computer computer;

        private void printToConsole(String line) {
            if (this.step.streamStdOutToConsolePrefix == null || this.step.streamStdOutToConsolePrefix.trim().isEmpty()) {
                return;
            }
            String prefix = "[" + this.step.streamStdOutToConsolePrefix + "] ";
            this.listener.getLogger().println(prefix + line);
            this.listener.getLogger().flush();
        }

        protected OcActionResult run() throws IOException, InterruptedException, ExecutionException {
            if (this.filePath != null && !this.filePath.exists()) {
                this.filePath.mkdirs();
            }
            if (this.step.streamStdOutToConsolePrefix != null && this.step.streamStdOutToConsolePrefix.startsWith("start-build")) {
                this.listener.getLogger().println("NOTE: the selector returned when -F/--follow is supplied to startBuild() will be inoperative for the various selector operations.");
                this.listener.getLogger().println("Consider removing those options from startBuild and using the logs() command to follow the build output.");
            }
            String commandString = this.step.cmdBuilder.asString(false);
            String[] command = QuotedStringTokenizer.tokenize((String)commandString);
            command = ClientCommandBuilder.fixPathInCommandArray(command, this.envVars, this.listener, this.filePath, this.launcher, this.step.verbose);
            StringBuffer stdout = new StringBuffer();
            StringBuffer stderr = new StringBuffer();
            ClientCommandRunner runner = new ClientCommandRunner(command, this.filePath, this.envVars, line -> {
                stdout.append(line).append('\n');
                this.printToConsole(line);
                return false;
            }, line -> {
                stderr.append(line).append('\n');
                this.printToConsole(line);
                return false;
            });
            int exitStatus = -1;
            try {
                exitStatus = runner.run(this.launcher);
            }
            catch (Throwable ex) {
                this.getContext().onFailure(ex);
            }
            OcActionResult result = new OcActionResult();
            result.status = exitStatus;
            result.verb = ((OcAction)this.step).cmdBuilder.verb;
            result.cmd = this.step.cmdBuilder.asString(true);
            result.reference = this.step.reference;
            result.out = stdout.toString();
            result.err = stderr.toString();
            if (this.step.verbose) {
                this.listener.getLogger().println("Verbose sub-step output:");
                this.listener.getLogger().println("\tCommand> " + result.cmd);
                this.listener.getLogger().println("\tStatus> " + result.status);
                this.listener.getLogger().println("\tStdOut>" + result.out);
                this.listener.getLogger().println("\tStdErr> " + result.err);
                this.listener.getLogger().println("\tReference> " + result.reference);
            }
            return result;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return OcAction.FUNCTION_NAME;
        }

        public String getDisplayName() {
            return "Internal utility function for OpenShift DSL";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class OcActionResult
    implements Serializable {
        @Whitelisted
        public String verb;
        @Whitelisted
        public String cmd;
        @Whitelisted
        public String out;
        @Whitelisted
        public String err;
        @Whitelisted
        public int status;
        @Whitelisted
        public HashMap<String, String> reference = new HashMap();

        public HashMap toMap() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("verb", this.verb);
            m.put("cmd", this.cmd);
            m.put("out", this.out);
            m.put("err", this.err);
            m.put("reference", this.reference);
            m.put("status", this.status);
            return m;
        }

        @Whitelisted
        public String toString() {
            return this.toMap().toString();
        }

        public boolean isFailed() {
            return this.status != 0;
        }

        public void failIf(String failMessage) throws AbortException {
            if (this.isFailed()) {
                throw new AbortException(failMessage + "; action failed: " + this.toString());
            }
        }
    }
}

