/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.internal.restclient.DefaultClient;
import com.openshift.restclient.BadRequestException;
import com.openshift.restclient.IClient;
import com.openshift.restclient.IOpenShiftWatchListener;
import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.IWatcher;
import com.openshift.restclient.NotFoundException;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.UnsupportedVersionException;
import com.openshift.restclient.api.ITypeFactory;
import com.openshift.restclient.authorization.IAuthorizationContext;
import com.openshift.restclient.authorization.ResourceForbiddenException;
import com.openshift.restclient.authorization.UnauthorizedException;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.ICapability;
import com.openshift.restclient.model.IList;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.JSONSerializeable;
import hudson.model.TaskListener;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class RetryIClient
implements IClient {
    private static int MAX_RETRY = 3;
    private final IClient client;
    private final TaskListener listener;

    private OpenShiftException handleError(Throwable t, Object call) throws OpenShiftException {
        OpenShiftException ose = null;
        if (t instanceof BadRequestException || t instanceof ResourceForbiddenException || t instanceof UnauthorizedException || t instanceof NotFoundException) {
            throw (OpenShiftException)t;
        }
        ose = !(t instanceof OpenShiftException) ? new OpenShiftException(t, "retry", new Object[]{call}) : (OpenShiftException)t;
        if (ose.getMessage().contains("409") && ose.getMessage().contains("response code")) {
            throw ose;
        }
        if (ose.getCause() != null && ose.getCause().getMessage().contains("409") && ose.getCause().getMessage().contains("response code")) {
            throw ose;
        }
        this.listener.getLogger().println(String.format("\nAn exception occurred invoking a REST operation against the OpenShift master.  The operation will be retried.  Exception message \"%s\".", t.getMessage()));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new OpenShiftException((Throwable)e, "retry", new Object[]{call});
        }
        return ose;
    }

    private Object retry(Callable<Object> call) throws OpenShiftException {
        OpenShiftException ose = null;
        for (int retryCount = 0; retryCount < MAX_RETRY; ++retryCount) {
            try {
                Object o = call.call();
                return o;
            }
            catch (Throwable t) {
                ose = this.handleError(t, call);
                continue;
            }
        }
        if (ose.getCause() != null) {
            this.listener.getLogger().println(String.format("\nAfter a few retries, giving up invoking the REST operation against the OpenShift master.  Final exception message \"%s\".", ose.getCause().getMessage()));
        } else {
            this.listener.getLogger().println(String.format("\nAfter a few retries, giving up invoking the REST operation against the OpenShift master.  Final exception message \"%s\".", ose.getMessage()));
        }
        throw ose;
    }

    private void retry(Runnable call) throws OpenShiftException {
        OpenShiftException ose = null;
        for (int retryCount = 0; retryCount < MAX_RETRY; ++retryCount) {
            try {
                call.run();
                return;
            }
            catch (Throwable t) {
                ose = this.handleError(t, call);
                continue;
            }
        }
        if (ose.getCause() != null) {
            this.listener.getLogger().println(String.format("\nAfter a few retries, giving up invoking the REST operation against the OpenShift master.  Final exception message \"%s\".", ose.getCause().getMessage()));
        } else {
            this.listener.getLogger().println(String.format("\nAfter a few retries, giving up invoking the REST operation against the OpenShift master.  Final exception message \"%s\".", ose.getMessage()));
        }
        throw ose;
    }

    public RetryIClient(IClient c, TaskListener l) {
        this.client = c;
        this.listener = l;
    }

    public DefaultClient getDefaultClient() {
        return (DefaultClient)this.client;
    }

    public <T extends ICapability> T getCapability(Class<T> capability) {
        return (T)this.client.getCapability(capability);
    }

    public boolean supports(Class<? extends ICapability> capability) {
        return this.client.supports(capability);
    }

    public <T extends ICapability, R> R accept(CapabilityVisitor<T, R> visitor, R unsupportedCapabililityValue) {
        return (R)this.client.accept(visitor, unsupportedCapabililityValue);
    }

    public IWatcher watch(String namespace, IOpenShiftWatchListener listener, String ... kinds) {
        return this.client.watch(namespace, listener, kinds);
    }

    public IWatcher watch(IOpenShiftWatchListener listener, String ... kinds) {
        return this.client.watch(listener, kinds);
    }

    public <T extends IResource> List<T> list(String kind) {
        return (List)this.retry(() -> this.client.list(kind));
    }

    public <T extends IResource> List<T> list(String kind, Map<String, String> labels) {
        return (List)this.retry(() -> this.client.list(kind, labels));
    }

    public <T extends IResource> List<T> list(String kind, String namespace) {
        return (List)this.retry(() -> this.client.list(kind, namespace));
    }

    public <T extends IResource> List<T> list(String kind, String namespace, Map<String, String> labels) {
        return (List)this.retry(() -> this.client.list(kind, namespace, labels));
    }

    public <T extends IResource> List<T> list(String kind, String namespace, String labelQuery) {
        return (List)this.retry(() -> this.client.list(kind, namespace, labelQuery));
    }

    public <T extends IResource> T get(String kind, String name, String namespace) {
        return (T)((IResource)this.retry(() -> this.client.get(kind, name, namespace)));
    }

    public IList get(String kind, String namespace) {
        return (IList)this.retry(() -> this.client.get(kind, namespace));
    }

    public <T extends IResource> T create(T resource) {
        return (T)((IResource)this.retry(() -> this.client.create(resource)));
    }

    public <T extends IResource> T create(T resource, String namespace) {
        return (T)((IResource)this.retry(() -> this.client.create(resource, namespace)));
    }

    public <T extends IResource> T create(String kind, String namespace, String name, String subresource, IResource payload) {
        return (T)((IResource)this.retry(() -> this.client.create(kind, namespace, name, subresource, payload)));
    }

    public Collection<IResource> create(IList list, String namespace) {
        return (Collection)this.retry(() -> this.client.create(list, namespace));
    }

    public <T extends IResource> T update(T resource) {
        return (T)((IResource)this.retry(() -> this.client.update(resource)));
    }

    public <T extends IResource> void delete(T resource) {
        this.retry(() -> this.client.delete(resource));
    }

    public <T extends IResource> T execute(String httpMethod, String kind, String namespace, String name, String subresource, IResource payload) {
        return (T)((IResource)this.retry(() -> this.client.execute(httpMethod, kind, namespace, name, subresource, payload)));
    }

    public <T extends IResource> T execute(String httpMethod, String kind, String namespace, String name, String subresource, IResource payload, Map<String, String> params) {
        return (T)((IResource)this.retry(() -> this.client.execute(httpMethod, kind, namespace, name, subresource, payload, params)));
    }

    public <T extends IResource> T execute(String httpMethod, String kind, String namespace, String name, String subresource, IResource payload, String subcontext) {
        return (T)((IResource)this.retry(() -> this.client.execute(httpMethod, kind, namespace, name, subresource, payload, subcontext)));
    }

    public <T> T execute(ITypeFactory factory, String httpMethod, String kind, String namespace, String name, String subresource, String subContext, JSONSerializeable payload, Map<String, String> params) {
        return (T)this.retry(() -> this.client.execute(factory, httpMethod, kind, namespace, name, subresource, subContext, payload, params));
    }

    public URL getBaseURL() {
        return this.client.getBaseURL();
    }

    public String getResourceURI(IResource resource) {
        return this.client.getResourceURI(resource);
    }

    public String getOpenShiftAPIVersion() throws UnsupportedVersionException {
        return this.client.getOpenShiftAPIVersion();
    }

    public IAuthorizationContext getAuthorizationContext() {
        return this.client.getAuthorizationContext();
    }

    public IResourceFactory getResourceFactory() {
        return this.client.getResourceFactory();
    }

    public String getServerReadyStatus() {
        return (String)this.retry(() -> this.client.getServerReadyStatus());
    }

    public IClient clone() {
        return new RetryIClient(this.client.clone(), this.listener);
    }

    public String getKubernetesMasterVersion() {
        return this.client.getKubernetesMasterVersion();
    }

    public String getOpenshiftMasterVersion() {
        return this.client.getOpenshiftMasterVersion();
    }
}

