/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPlugin;
import hudson.model.TaskListener;
import java.util.Map;

public interface ITimedOpenShiftPlugin
extends IOpenShiftPlugin {
    public String getWaitTime();

    public String getWaitUnit();

    public long getGlobalTimeoutConfiguration();

    default public long getTimeout(TaskListener listener, boolean chatty, Map<String, String> overrides) {
        long global = this.getGlobalTimeoutConfiguration();
        String field = this.getOverride(this.getWaitTime(), overrides);
        TimeoutUnit unit = TimeoutUnit.getByName(this.getWaitUnit());
        long chosen = unit.toMilliseconds(field, global);
        if (chatty) {
            listener.getLogger().println("Found global job type timeout configuration: " + global + " milliseconds");
            if (field == null || field.trim().isEmpty()) {
                listener.getLogger().println("No local timeout configured for this step");
            } else {
                listener.getLogger().println("Local step timeout configuration: " + field + " " + (Object)((Object)unit));
            }
        }
        listener.getLogger().println("Operation will timeout after " + chosen + " milliseconds");
        return chosen;
    }

    public static enum TimeoutUnit {
        MILLISECONDS("milli", 1L),
        SECONDS("sec", 1000L),
        MINUTES("min", 60000L);

        public final String name;
        public final long multiplier;

        private TimeoutUnit(String name, long multiplier) {
            this.name = name;
            this.multiplier = multiplier;
        }

        public String toString() {
            return this.name;
        }

        public boolean matches(String value) {
            if (value == null || value.trim().isEmpty()) {
                return false;
            }
            return this.name.equalsIgnoreCase(value);
        }

        public static TimeoutUnit getByName(String unit) {
            if (unit == null || unit.trim().isEmpty()) {
                unit = "milli";
            }
            unit = unit.trim();
            for (TimeoutUnit tu : TimeoutUnit.values()) {
                if (!tu.name.equalsIgnoreCase(unit)) continue;
                return tu;
            }
            throw new IllegalArgumentException("Unexpected time unit name: " + unit);
        }

        public static String normalize(String value) {
            if (value == null || value.trim().isEmpty()) {
                return MILLISECONDS.toString();
            }
            return value.trim().toString();
        }

        public long toMilliseconds(String value, long def) {
            if (value == null || value.trim().isEmpty()) {
                return def;
            }
            long l = Long.parseLong(value);
            return l *= this.multiplier;
        }
    }
}

