/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPlugin;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.IService;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;

public interface IOpenShiftServiceVerifier
extends IOpenShiftPlugin {
    public static final String DISPLAY_NAME = "Verify OpenShift Service";

    @Override
    default public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getSvcName();

    public String getRetryCount();

    public String getRetryCount(Map<String, String> var1);

    default public String getSvcName(Map<String, String> overrides) {
        return this.getOverride(this.getSvcName(), overrides);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public boolean coreLogic(Launcher launcher, TaskListener listener, Map<String, String> overrides) {
        boolean chatty = Boolean.parseBoolean(this.getVerbose(overrides));
        listener.getLogger().println(String.format("\n\nStarting \"%s\" for the service \"%s\" from the project \"%s\".", DISPLAY_NAME, this.getSvcName(overrides), this.getNamespace(overrides)));
        IClient client = this.getClient(listener, DISPLAY_NAME, overrides);
        String spec = null;
        if (client != null) {
            IService svc = (IService)client.get("Service", this.getSvcName(overrides), this.getNamespace(overrides));
            String ip = svc.getClusterIP();
            int port = svc.getPort();
            spec = ip + ":" + port;
            int tryCount = 0;
            if (chatty) {
                listener.getLogger().println("\nOpenShiftServiceVerifier retry " + this.getRetryCount(overrides));
            }
            listener.getLogger().println(String.format("  Attempting to connect to \"%s\" ...", spec));
            while (tryCount < Integer.parseInt(this.getRetryCount(overrides))) {
                ++tryCount;
                if (chatty) {
                    listener.getLogger().println("\nOpenShiftServiceVerifier attempt connect to " + spec + " attempt " + tryCount);
                }
                InetSocketAddress address = new InetSocketAddress(ip, port);
                Socket socket = null;
                try {
                    socket = new Socket();
                    socket.connect(address, 2500);
                    listener.getLogger().println(String.format("\n\nExiting \"%s\" successfully; a connection to \"%s\" was made.", DISPLAY_NAME, spec));
                    boolean bl = true;
                    return bl;
                }
                catch (IOException e) {
                    if (chatty) {
                        e.printStackTrace(listener.getLogger());
                    }
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        if (!chatty) continue;
                        e.printStackTrace(listener.getLogger());
                    }
                }
            }
        } else {
            return false;
        }
        listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully; a connection to \"%s\" could not be made.", DISPLAY_NAME, spec));
        return false;
    }
}

