/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.jenkins.plugins.pipeline.model.GlobalConfig;
import com.openshift.jenkins.plugins.pipeline.model.ITimedOpenShiftPlugin;
import com.openshift.restclient.IClient;
import com.openshift.restclient.api.capabilities.IScalable;
import com.openshift.restclient.apis.autoscaling.models.IScale;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IReplicationController;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public interface IOpenShiftScaler
extends ITimedOpenShiftPlugin {
    public static final String DISPLAY_NAME = "Scale OpenShift Deployment";

    @Override
    default public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getDepCfg();

    public String getReplicaCount();

    public String getVerifyReplicaCount();

    @Override
    default public long getGlobalTimeoutConfiguration() {
        return GlobalConfig.getScalerWait();
    }

    default public String getDepCfg(Map<String, String> overrides) {
        return this.getOverride(this.getDepCfg(), overrides);
    }

    default public String getReplicaCount(Map<String, String> overrides) {
        return this.getOverride(this.getReplicaCount(), overrides);
    }

    default public String getVerifyReplicaCount(Map<String, String> overrides) {
        return this.getOverride(this.getVerifyReplicaCount(), overrides);
    }

    @Override
    default public boolean coreLogic(Launcher launcher, TaskListener listener, Map<String, String> overrides) throws InterruptedException {
        boolean chatty = Boolean.parseBoolean(this.getVerbose(overrides));
        boolean checkCount = Boolean.parseBoolean(this.getVerifyReplicaCount(overrides));
        listener.getLogger().println(String.format("\n\nStarting \"%s\" with deployment config \"%s\" from the project \"%s\".", DISPLAY_NAME, this.getDepCfg(overrides), this.getNamespace(overrides)));
        IClient client = this.getClient(listener, DISPLAY_NAME, overrides);
        if (client != null) {
            IReplicationController rc = null;
            IDeploymentConfig dc = null;
            long currTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            if (!checkCount) {
                listener.getLogger().println(String.format("  Scaling to \"%s\" replicas ...", this.getReplicaCount(overrides)));
            } else {
                listener.getLogger().println(String.format(" Scaling to \"%s\" replicas and verifying the replica count is reached ...", this.getReplicaCount(overrides)));
            }
            boolean scaleDone = false;
            long wait = this.getTimeout(listener, chatty, overrides);
            while (TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) < currTime + wait) {
                dc = (IDeploymentConfig)client.get("DeploymentConfig", this.getDepCfg(overrides), this.getNamespace(overrides));
                if (dc == null) {
                    listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully; the deployment config \"%s\" could not be read.", DISPLAY_NAME, this.getDepCfg(overrides)));
                    return false;
                }
                if (dc.getLatestVersionNumber() > 0) {
                    rc = this.getLatestReplicationController(dc, this.getNamespace(overrides), client, (TaskListener)(chatty ? listener : null));
                    final int count = Integer.decode(this.getReplicaCount(overrides));
                    boolean bl = scaleDone = rc.getCurrentReplicaCount() == count;
                    if (chatty) {
                        listener.getLogger().println("\nOpenShiftScaler setting desired replica count of " + this.getReplicaCount(overrides) + " on " + rc + " scaleDone " + scaleDone);
                    }
                    if (!scaleDone) {
                        IScale result = (IScale)dc.accept((CapabilityVisitor)new CapabilityVisitor<IScalable, IScale>(){

                            public IScale visit(IScalable capability) {
                                return capability.scaleTo(count);
                            }
                        }, null);
                        if (chatty) {
                            listener.getLogger().println("\nOpenShiftScaler scale result " + result);
                        }
                        rc = this.getLatestReplicationController(dc, this.getNamespace(overrides), client, (TaskListener)(chatty ? listener : null));
                        scaleDone = this.isReplicationControllerScaledAppropriately(rc, checkCount, count);
                    }
                } else if (this.getReplicaCount(overrides).equals("0")) {
                    listener.getLogger().println(String.format("\n\nExiting \"Scale OpenShift Deployment\" successfully; no deployments for \"%s\" were found, so a replica count of \"0\" already exists.", this.getDepCfg(overrides)));
                    return true;
                }
                if (scaleDone) break;
                if (chatty) {
                    listener.getLogger().println("\nOpenShiftScaler will wait 10 seconds, then try to scale again");
                }
                Thread.sleep(10000L);
            }
            if (!scaleDone) {
                if (!checkCount) {
                    listener.getLogger().println(String.format("\n\nExiting \"Scale OpenShift Deployment\" unsuccessfully; the call to \"%s\" failed.", this.getApiURL(overrides)));
                } else {
                    listener.getLogger().println(String.format("\n\nExiting \"Scale OpenShift Deployment\" unsuccessfully; the deployment \"%s\" did not reach \"%s\" replica(s) in time.", rc != null ? rc.getName() : "<deployment not found>", this.getReplicaCount(overrides)));
                }
                return false;
            }
            if (!checkCount) {
                listener.getLogger().println(String.format("\n\nExiting \"Scale OpenShift Deployment\" successfully for deployment \"%s\".", rc.getName()));
            } else {
                listener.getLogger().println(String.format("\n\nExiting \"Scale OpenShift Deployment\" successfully, where the deployment \"%s\" reached \"%s\" replica(s).", rc.getName(), this.getReplicaCount(overrides)));
            }
            return true;
        }
        return false;
    }
}

