/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.jenkins.plugins.pipeline.OpenShiftApiObjHandler;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftApiObjHandler;
import com.openshift.restclient.IClient;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public interface IOpenShiftDeleterLabels
extends IOpenShiftApiObjHandler {
    public static final String DISPLAY_NAME = "Delete OpenShift Resource(s) using Labels";

    @Override
    default public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getTypes();

    public String getKeys();

    public String getValues();

    default public String getTypes(Map<String, String> overrides) {
        return this.getOverride(this.getTypes(), overrides);
    }

    default public String getKeys(Map<String, String> overrides) {
        return this.getOverride(this.getKeys(), overrides);
    }

    default public String getValues(Map<String, String> overrides) {
        return this.getOverride(this.getValues(), overrides);
    }

    @Override
    default public boolean coreLogic(Launcher launcher, TaskListener listener, Map<String, String> overrides) {
        boolean chatty = Boolean.parseBoolean(this.getVerbose(overrides));
        listener.getLogger().println(String.format("\n\nStarting \"%s\" with the project \"%s\".", DISPLAY_NAME, this.getNamespace(overrides)));
        this.updateApiTypes(chatty, listener, overrides);
        IClient client = this.getClient(listener, DISPLAY_NAME, overrides);
        if (client != null) {
            String[] inputValues;
            Set<String> types = OpenShiftApiObjHandler.apiMap.keySet();
            String resourceKind = null;
            int deletes = 0;
            String[] inputTypes = this.getTypes(overrides).split(",");
            String[] inputKeys = this.getKeys(overrides).split(",");
            if (inputKeys.length != (inputValues = this.getValues(overrides).split(",")).length) {
                listener.getLogger().println(String.format("\n\nExiting \"Delete OpenShift Resource(s) by Key\" unsuccessfully, because %d types(s) were specified but %d keys(s) were specified.", inputValues.length, inputKeys.length));
                return false;
            }
            ArrayList<Map<String, String>> listOfLabels = new ArrayList<Map<String, String>>();
            for (int j = 0; j < inputKeys.length; ++j) {
                HashMap<String, String> labels = new HashMap<String, String>();
                labels.put(inputKeys[j], inputValues[j]);
                listOfLabels.add(labels);
            }
            for (int i = 0; i < inputTypes.length; ++i) {
                if (OpenShiftApiObjHandler.typeShortcut.containsKey(inputTypes[i])) {
                    resourceKind = OpenShiftApiObjHandler.typeShortcut.get(inputTypes[i]);
                } else {
                    for (String type : types) {
                        if (!type.equalsIgnoreCase(inputTypes[i])) continue;
                        resourceKind = type;
                        break;
                    }
                }
                if (resourceKind == null) {
                    listener.getLogger().println(String.format("  The API resource \"%s\" is not currently supported by this step.", inputTypes[i]));
                    continue;
                }
                int[] rc = new int[2];
                rc = this.deleteAPIObjs(client, listener, this.getNamespace(overrides), resourceKind, null, listOfLabels, chatty);
                deletes += rc[0];
            }
            listener.getLogger().println(String.format("\n\nExiting \"%s\" successfully, with %d resource(s) deleted.", DISPLAY_NAME, deletes));
            return true;
        }
        return false;
    }
}

