/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.jenkins.plugins.pipeline.OpenShiftApiObjHandler;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPlugin;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.IResource;
import hudson.model.TaskListener;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.jboss.dmr.ModelNode;
import org.yaml.snakeyaml.Yaml;

public interface IOpenShiftApiObjHandler
extends IOpenShiftPlugin {
    default public String fetchApiJsonFromApiServer(boolean chatty, TaskListener listener, Map<String, String> overrides, String apiDomain) {
        String json = null;
        try {
            json = this.httpGet(chatty, listener, overrides, this.getApiURL(overrides) + "/swaggerapi" + apiDomain + "/v1");
        }
        catch (Throwable t) {
            if (chatty) {
                listener.getLogger().println(t.getMessage());
            }
            json = this.httpGet(chatty, listener, overrides, this.getApiURL(overrides) + "/apis");
        }
        return json;
    }

    default public void importJsonOfApiTypes(boolean chatty, TaskListener listener, Map<String, String> overrides, String apiDomain, String json) {
        if (json == null) {
            return;
        }
        ModelNode oapis = ModelNode.fromJSONString((String)json);
        if (oapis.has("apis")) {
            ModelNode apis = oapis.get("apis");
            List apiList = apis.asList();
            for (ModelNode api : apiList) {
                String path = api.get("path").asString();
                ModelNode operations = api.get("operations");
                List operationList = operations.asList();
                for (ModelNode operation : operationList) {
                    String[] pathPieces;
                    String coreType;
                    String type = operation.get("type").asString();
                    String method = operation.get("method").asString();
                    if (!type.startsWith("v1.") || !method.equalsIgnoreCase("POST") || OpenShiftApiObjHandler.apiMap.containsKey(coreType = type.substring(3))) continue;
                    String typeStrForURL = null;
                    for (String pathPiece : pathPieces = path.split("/")) {
                        if (!pathPiece.equalsIgnoreCase(coreType + "s") && !pathPiece.equalsIgnoreCase(coreType)) continue;
                        typeStrForURL = pathPiece;
                        break;
                    }
                    if (typeStrForURL == null) continue;
                    if (chatty) {
                        listener.getLogger().println("\nOpenShiftCreator: adding from API server swagger endpoint new type " + coreType + " with url str " + typeStrForURL + " to domain " + apiDomain);
                    }
                    OpenShiftApiObjHandler.apiMap.put(coreType, new String[]{apiDomain, typeStrForURL});
                }
            }
        }
        if (oapis.has("groups")) {
            ModelNode groups = oapis.get("groups");
            List groupList = groups.asList();
            for (ModelNode group : groupList) {
                String groupjson;
                String name;
                block14: {
                    name = group.get("name").asString();
                    groupjson = null;
                    try {
                        groupjson = this.httpGet(chatty, listener, overrides, this.getApiURL(overrides) + "/apis/" + name + "/v1");
                    }
                    catch (Throwable t) {
                        if (!chatty) break block14;
                        listener.getLogger().println(t.getMessage());
                    }
                }
                if (groupjson == null) continue;
                ModelNode groupjsonNode = ModelNode.fromJSONString(groupjson);
                ModelNode resources = groupjsonNode.get("resources");
                List resourceList = resources.asList();
                for (ModelNode resource : resourceList) {
                    String value;
                    String kind = resource.get("kind").asString();
                    if (OpenShiftApiObjHandler.apiMap.containsKey(kind)) continue;
                    if (chatty) {
                        listener.getLogger().println("\nOpenShiftCreator: adding from API server swagger endpoint new type " + kind + " is openshift " + name.contains("openshift"));
                    }
                    if (!(value = kind.toLowerCase()).endsWith("s")) {
                        value = value + "s";
                    }
                    if (name.contains("openshift")) {
                        OpenShiftApiObjHandler.apiMap.put(kind, new String[]{"/oapi", kind.toLowerCase()});
                        continue;
                    }
                    OpenShiftApiObjHandler.apiMap.put(kind, new String[]{"/api", kind.toLowerCase()});
                }
            }
        }
    }

    default public void updateApiTypes(boolean chatty, TaskListener listener, Map<String, String> overrides) {
        this.importJsonOfApiTypes(chatty, listener, overrides, "/oapi", this.fetchApiJsonFromApiServer(chatty, listener, overrides, "/oapi"));
        this.importJsonOfApiTypes(chatty, listener, overrides, "/api", this.fetchApiJsonFromApiServer(chatty, listener, overrides, "/api"));
    }

    default public ModelNode hydrateJsonYaml(String jsonyaml, TaskListener listener) {
        ModelNode resources;
        block4: {
            resources = null;
            try {
                resources = ModelNode.fromJSONString((String)jsonyaml);
            }
            catch (Exception e) {
                Yaml yaml = new Yaml();
                Map map = (Map)yaml.load(jsonyaml);
                JSONObject jsonObj = JSONObject.fromObject((Object)map);
                try {
                    resources = ModelNode.fromJSONString((String)jsonObj.toString());
                }
                catch (Throwable t) {
                    if (listener == null) break block4;
                    t.printStackTrace(listener.getLogger());
                }
            }
        }
        return resources;
    }

    default public int[] deleteAPIObjs(IClient client, TaskListener listener, String namespace, String type, String key, List<Map<String, String>> listOfLabels, boolean chatty) {
        int[] ret = new int[2];
        int deleted = 0;
        int failed = 0;
        if (chatty) {
            listener.getLogger().println(String.format("deleteAPIObjs with namespace %s type %s key %s labels %s", namespace, type, key, listOfLabels));
        }
        if (type != null && key != null) {
            IResource resource = client.get(type, key, namespace);
            if (resource != null) {
                client.delete(resource);
                listener.getLogger().println(String.format("  Deleted a \"%s\" with key \"%s\"", type, key));
                ++deleted;
            } else {
                listener.getLogger().println(String.format("  Failed to delete a \"%s\" with key \"%s\"", type, key));
                ++failed;
            }
        }
        if (listOfLabels != null && listOfLabels.size() > 0) {
            for (Map<String, String> labels : listOfLabels) {
                if (chatty) {
                    listener.getLogger().println(String.format("deleteAPIObjs calling list with type %s namespace %s labels %s", type, namespace, labels));
                }
                List resources = client.list(type, namespace, labels);
                for (IResource resource : resources) {
                    if (resource == null) continue;
                    if (chatty) {
                        listener.getLogger().println("deleteAPIObjs calling delete on " + resource.toJson(false));
                    }
                    client.delete(resource);
                    listener.getLogger().println(String.format("  Deleted a \"%s\" with key \"%s\"", type, resource.getName()));
                    ++deleted;
                }
            }
        }
        ret[0] = deleted;
        ret[1] = failed;
        return ret;
    }
}

