/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.dsl;

import com.openshift.jenkins.plugins.pipeline.ParamVerify;
import com.openshift.jenkins.plugins.pipeline.dsl.OpenShiftScalerExecution;
import com.openshift.jenkins.plugins.pipeline.dsl.TimedOpenShiftBaseStep;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPluginDescriptor;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftScaler;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepMonitor;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class OpenShiftScaler
extends TimedOpenShiftBaseStep
implements IOpenShiftScaler {
    protected final String depCfg;
    protected final String replicaCount;
    protected String verifyReplicaCount;
    private static final Logger LOGGER = Logger.getLogger(OpenShiftScaler.class.getName());

    @DataBoundConstructor
    public OpenShiftScaler(String depCfg, String replicaCount) {
        this.depCfg = depCfg != null ? depCfg.trim() : null;
        this.replicaCount = replicaCount != null ? replicaCount.trim() : null;
    }

    @Override
    public String getDepCfg() {
        return this.depCfg;
    }

    @Override
    public String getReplicaCount() {
        return this.replicaCount;
    }

    @Override
    public String getVerifyReplicaCount() {
        return this.verifyReplicaCount;
    }

    @DataBoundSetter
    public void setVerifyReplicaCount(String verifyReplicaCount) {
        this.verifyReplicaCount = verifyReplicaCount != null ? verifyReplicaCount.trim() : null;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl
    implements IOpenShiftPluginDescriptor {
        public DescriptorImpl() {
            super(OpenShiftScalerExecution.class);
        }

        public String getFunctionName() {
            return "openshiftScale";
        }

        public String getDisplayName() {
            return "Scale OpenShift Deployment";
        }

        public Step newInstance(Map<String, Object> arguments) throws Exception {
            Object verifyReplicaCount;
            if (!arguments.containsKey("deploymentConfig") && !arguments.containsKey("depCfg")) {
                throw new IllegalArgumentException("need to specify deploymentConfig");
            }
            Object depCfg = arguments.get("deploymentConfig");
            if (depCfg == null || depCfg.toString().trim().length() == 0) {
                depCfg = arguments.get("depCfg");
            }
            if (depCfg == null || depCfg.toString().trim().length() == 0) {
                throw new IllegalArgumentException("need to specify deploymentConfig");
            }
            if (!arguments.containsKey("replicaCount")) {
                throw new IllegalArgumentException("need to specif replicaCount");
            }
            OpenShiftScaler step = new OpenShiftScaler(depCfg.toString(), arguments.get("replicaCount").toString());
            if (arguments.containsKey("verifyReplicaCount") && (verifyReplicaCount = arguments.get("verifyReplicaCount")) != null) {
                step.setVerifyReplicaCount(verifyReplicaCount.toString());
            }
            ParamVerify.updateTimedDSLBaseStep(arguments, step);
            return step;
        }
    }
}

