/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.dsl;

import com.openshift.jenkins.plugins.pipeline.ParamVerify;
import com.openshift.jenkins.plugins.pipeline.dsl.OpenShiftBaseStep;
import com.openshift.jenkins.plugins.pipeline.dsl.OpenShiftImageTaggerExecution;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftImageTagger;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPluginDescriptor;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepMonitor;
import java.util.Collection;
import java.util.Map;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class OpenShiftImageTagger
extends OpenShiftBaseStep
implements IOpenShiftImageTagger {
    protected final String srcTag;
    protected final String destTag;
    protected final String srcStream;
    protected final String destStream;
    protected String destinationNamespace;
    protected String destinationAuthToken;
    protected String alias;

    @DataBoundConstructor
    public OpenShiftImageTagger(String srcStream, String srcTag, String destStream, String destTag) {
        this.srcStream = srcStream != null ? srcStream.trim() : null;
        this.srcTag = srcTag != null ? srcTag.trim() : null;
        this.destStream = destStream != null ? destStream.trim() : null;
        this.destTag = destTag != null ? destTag.trim() : null;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @DataBoundSetter
    public void setAlias(String alias) {
        this.alias = alias != null ? alias.trim() : null;
    }

    @Deprecated
    public String getTestTag() {
        return this.srcTag;
    }

    @Override
    public String getSrcTag() {
        return this.srcTag;
    }

    @Deprecated
    public String getProdTag() {
        return this.destTag;
    }

    @Override
    public String getDestTag() {
        return this.destTag;
    }

    @Deprecated
    public String getTestStream() {
        return this.srcStream;
    }

    @Override
    public String getSrcStream() {
        return this.srcStream;
    }

    @Deprecated
    public String getProdStream() {
        return this.destStream;
    }

    @Override
    public String getDestStream() {
        return this.destStream;
    }

    @Override
    public String getDestinationNamespace() {
        return this.destinationNamespace;
    }

    @DataBoundSetter
    public void setDestinationNamespace(String destinationNamespace) {
        this.destinationNamespace = destinationNamespace != null ? destinationNamespace.trim() : null;
    }

    @Override
    public String getDestinationAuthToken() {
        return this.destinationAuthToken;
    }

    @DataBoundSetter
    public void setDestinationAuthToken(String destinationAuthToken) {
        this.destinationAuthToken = this.destinationNamespace != null ? destinationAuthToken.trim() : null;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl
    implements IOpenShiftPluginDescriptor {
        public DescriptorImpl() {
            super(OpenShiftImageTaggerExecution.class);
        }

        public String getFunctionName() {
            return "openshiftTag";
        }

        public String getDisplayName() {
            return "Tag OpenShift Image";
        }

        public Step newInstance(Map<String, Object> arguments) throws Exception {
            Object destinationAuthToken;
            Object destinationNamespace;
            Object alias;
            if (!(arguments.containsKey("sourceStream") || arguments.containsKey("destinationStream") || arguments.containsKey("sourceTag") || arguments.containsKey("destinationTag") || arguments.containsKey("destStream") || arguments.containsKey("destTag") || arguments.containsKey("srcTag") || arguments.containsKey("destStream") || arguments.containsKey("srcStream"))) {
                throw new IllegalArgumentException("need to specify sourceStream, sourceTag, destinationStream, destinationTag");
            }
            Object srcStream = arguments.get("sourceStream");
            Object srcTag = arguments.get("sourceTag");
            Object destStream = arguments.get("destinationStream");
            Object destTag = arguments.get("destinationTag");
            if (srcStream == null || srcStream.toString().trim().length() == 0) {
                srcStream = arguments.get("srcStream");
            }
            if (srcTag == null || srcTag.toString().trim().length() == 0) {
                srcTag = arguments.get("srcTag");
            }
            if (destStream == null || destStream.toString().trim().length() == 0) {
                destStream = arguments.get("destStream");
            }
            if (destTag == null || destTag.toString().trim().length() == 0) {
                destTag = arguments.get("destTag");
            }
            if (srcStream == null || srcStream.toString().trim().length() == 0 || srcTag == null || srcTag.toString().trim().length() == 0 || destStream == null || destStream.toString().trim().length() == 0 || destTag == null || destTag.toString().trim().length() == 0) {
                throw new IllegalArgumentException("need to specify sourceStream, sourceTag, destinationStream, destinationTag");
            }
            OpenShiftImageTagger step = new OpenShiftImageTagger(srcStream.toString(), srcTag.toString(), destStream.toString(), destTag.toString());
            if (arguments.containsKey("alias") && (alias = arguments.get("alias")) != null) {
                step.setAlias(alias.toString());
            }
            if (arguments.containsKey("destinationNamespace") && (destinationNamespace = arguments.get("destinationNamespace")) != null) {
                step.setDestinationNamespace(destinationNamespace.toString());
            }
            if (arguments.containsKey("destinationAuthToken") && (destinationAuthToken = arguments.get("destinationAuthToken")) != null) {
                step.setDestinationAuthToken(destinationAuthToken.toString());
            }
            ParamVerify.updateDSLBaseStep(arguments, step);
            return step;
        }
    }
}

