/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.dsl;

import com.openshift.jenkins.plugins.pipeline.ParamVerify;
import com.openshift.jenkins.plugins.pipeline.dsl.OpenShiftDeployerExecution;
import com.openshift.jenkins.plugins.pipeline.dsl.TimedOpenShiftBaseStep;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftDeployer;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPluginDescriptor;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepMonitor;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.kohsuke.stapler.DataBoundConstructor;

public class OpenShiftDeployer
extends TimedOpenShiftBaseStep
implements IOpenShiftDeployer {
    protected final String depCfg;
    private static final Logger LOGGER = Logger.getLogger(OpenShiftDeployer.class.getName());

    @DataBoundConstructor
    public OpenShiftDeployer(String depCfg) {
        this.depCfg = depCfg != null ? depCfg.trim() : null;
    }

    @Override
    public String getDepCfg() {
        return this.depCfg;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl
    implements IOpenShiftPluginDescriptor {
        public DescriptorImpl() {
            super(OpenShiftDeployerExecution.class);
        }

        public String getFunctionName() {
            return "openshiftDeploy";
        }

        public String getDisplayName() {
            return "Trigger OpenShift Deployment";
        }

        public Step newInstance(Map<String, Object> arguments) throws Exception {
            if (!arguments.containsKey("deploymentConfig") && !arguments.containsKey("depCfg")) {
                throw new IllegalArgumentException("need to specify deploymentConfig");
            }
            Object depCfg = arguments.get("deploymentConfig");
            if (depCfg == null || depCfg.toString().trim().length() == 0) {
                depCfg = arguments.get("depCfg");
            }
            if (depCfg == null || depCfg.toString().trim().length() == 0) {
                throw new IllegalArgumentException("need to specify deploymentConfig");
            }
            OpenShiftDeployer step = new OpenShiftDeployer(depCfg.toString());
            ParamVerify.updateTimedDSLBaseStep(arguments, step);
            return step;
        }
    }
}

