/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;

@Extension
public class OpenShiftItemListener
extends ItemListener {
    private void updateRootURLConfig() {
        if (Jenkins.getInstance().getRootUrl() != null && JenkinsLocationConfiguration.get().getUrl() == null) {
            JenkinsLocationConfiguration.get().setUrl(Jenkins.getInstance().getRootUrl());
        }
    }

    public void onCreated(Item item) {
        this.updateRootURLConfig();
        super.onCreated(item);
    }

    public void onCopied(Item src, Item item) {
        this.updateRootURLConfig();
        super.onCopied(src, item);
    }

    public void onLoaded() {
        this.updateRootURLConfig();
        super.onLoaded();
    }

    public void onDeleted(Item item) {
        this.updateRootURLConfig();
        super.onDeleted(item);
    }

    public void onRenamed(Item item, String oldName, String newName) {
        this.updateRootURLConfig();
        super.onRenamed(item, oldName, newName);
    }

    public void onLocationChanged(Item item, String oldFullName, String newFullName) {
        this.updateRootURLConfig();
        super.onLocationChanged(item, oldFullName, newFullName);
    }

    public void onUpdated(Item item) {
        this.updateRootURLConfig();
    }
}

