/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline;

import com.openshift.jenkins.plugins.pipeline.OpenShiftBaseStep;
import com.openshift.jenkins.plugins.pipeline.ParamVerify;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftImageTagger;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftPluginDescriptor;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class OpenShiftImageTagger
extends OpenShiftBaseStep
implements IOpenShiftImageTagger {
    protected final String testTag;
    protected final String prodTag;
    protected final String testStream;
    protected final String prodStream;
    protected final String destinationNamespace;
    protected final String destinationAuthToken;
    protected final String alias;

    @DataBoundConstructor
    public OpenShiftImageTagger(String apiURL, String testTag, String prodTag, String namespace, String authToken, String verbose, String testStream, String prodStream, String destinationNamespace, String destinationAuthToken, String alias) {
        super(apiURL, namespace, authToken, verbose);
        this.testTag = testTag != null ? testTag.trim() : null;
        this.prodTag = prodTag != null ? prodTag.trim() : null;
        this.prodStream = prodStream != null ? prodStream.trim() : null;
        this.testStream = testStream != null ? testStream.trim() : null;
        this.destinationAuthToken = destinationAuthToken != null ? destinationAuthToken.trim() : null;
        this.destinationNamespace = destinationNamespace != null ? destinationNamespace.trim() : null;
        this.alias = alias != null ? alias.trim() : null;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Deprecated
    public String getTestTag() {
        return this.testTag;
    }

    @Override
    public String getSrcTag() {
        return this.testTag;
    }

    @Deprecated
    public String getProdTag() {
        return this.prodTag;
    }

    @Override
    public String getDestTag() {
        return this.prodTag;
    }

    @Deprecated
    public String getTestStream() {
        return this.testStream;
    }

    @Override
    public String getSrcStream() {
        return this.testStream;
    }

    @Deprecated
    public String getProdStream() {
        return this.prodStream;
    }

    @Override
    public String getDestStream() {
        return this.prodStream;
    }

    @Override
    public String getDestinationNamespace() {
        return this.destinationNamespace;
    }

    @Override
    public String getDestinationAuthToken() {
        return this.destinationAuthToken;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder>
    implements IOpenShiftPluginDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckDestinationNamespace(@QueryParameter String value) throws IOException, ServletException {
            return ParamVerify.doCheckNamespace(value);
        }

        public FormValidation doCheckTestTag(@QueryParameter String value) throws IOException, ServletException {
            return ParamVerify.doCheckTestTag(value);
        }

        public FormValidation doCheckProdTag(@QueryParameter String value) throws IOException, ServletException {
            return ParamVerify.doCheckProdTag(value);
        }

        public FormValidation doCheckTestStream(@QueryParameter String value) throws IOException, ServletException {
            return ParamVerify.doCheckTestStream(value);
        }

        public FormValidation doCheckProdStream(@QueryParameter String value) throws IOException, ServletException {
            return ParamVerify.doCheckProdStream(value);
        }

        public FormValidation doCheckDestinationAuthToken(@QueryParameter String value) throws IOException, ServletException {
            return ParamVerify.doCheckDestTagToken(value);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Tag OpenShift Image";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

