/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline;

import com.openshift.restclient.ISSLCertificateCallback;
import hudson.model.TaskListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class Auth
implements ISSLCertificateCallback {
    static final Logger LOGGER = Logger.getLogger(Auth.class.getName());
    private static final String AUTH_FILE = "/run/secrets/kubernetes.io/serviceaccount/token";
    private static final String CERT_FILE = "/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    public static final String CERT_ARG = " --certificate-authority=/run/secrets/kubernetes.io/serviceaccount/ca.crt ";
    private Collection<X509Certificate> certs = null;
    private boolean skipTls = false;
    private TaskListener listener = null;
    private static X509TrustManager x509TrustManager;

    private Auth(Collection<X509Certificate> certs, TaskListener listener, boolean skipTls) {
        this.certs = certs;
        this.listener = listener;
        this.skipTls = skipTls;
    }

    public static Auth createInstance(TaskListener listener, String apiURL, Map<String, String> env) throws RuntimeException {
        boolean skip;
        Auth auth = null;
        File f = null;
        String certFile = env.get("CA_CERT_FILE");
        if (certFile != null && certFile.trim().length() > 0) {
            f = new File(certFile.trim());
        }
        if (f != null && !f.exists()) {
            throw new RuntimeException("CA_CERT_FILE location " + certFile + " does not exist");
        }
        if (f == null) {
            f = new File(CERT_FILE);
        }
        String skipVal = env.get("SKIP_TLS");
        String certVal = env.get("CA_CERT");
        boolean bl = skip = skipVal != null && !skipVal.trim().equalsIgnoreCase("false");
        if ((f.exists() || certVal != null) && !skip) {
            if (listener != null) {
                listener.getLogger().println("Auth - cert file exists - " + f.exists() + ", CA_CERT - " + certVal + "\n skip tls - " + skipVal);
            }
            try {
                auth = new Auth(Auth.createCert(f, certVal, listener, apiURL), listener, skip);
            }
            catch (Exception e) {
                if (listener != null) {
                    e.printStackTrace(listener.getLogger());
                }
                throw new RuntimeException(e);
            }
        } else if (skip) {
            auth = new Auth(null, listener, skip);
        } else {
            throw new RuntimeException("You have not specified SKIP_TLS, but a cert is not accessible.  See https://github.com/openshift/jenkins-plugin#certificates-and-encryption");
        }
        return auth;
    }

    public static X509TrustManager createLocalTrustStore(Auth auth, String apiURL) {
        block7: {
            if (auth.useCert()) {
                try {
                    ((X509Certificate)auth.getCerts().toArray()[0]).checkValidity();
                    if (auth.listener != null) {
                        auth.listener.getLogger().println("Auth - x509 created cert is " + auth.getCerts().toArray()[0].toString());
                    }
                    URI uri = new URI(apiURL);
                    KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                    ks.load(null, null);
                    int i = 0;
                    for (X509Certificate cert : auth.getCerts()) {
                        ks.setCertificateEntry(uri.toASCIIString() + i, cert);
                        ++i;
                    }
                    TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmfactory.init(ks);
                    x509TrustManager = null;
                    for (TrustManager trustManager : tmfactory.getTrustManagers()) {
                        if (!(trustManager instanceof X509TrustManager)) continue;
                        x509TrustManager = (X509TrustManager)trustManager;
                        if (auth.listener != null) {
                            auth.listener.getLogger().println("Auth - x509 trust mgr certs " + Arrays.toString(x509TrustManager.getAcceptedIssuers()));
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    if (auth.listener == null) break block7;
                    t.printStackTrace(auth.listener.getLogger());
                }
            }
        }
        return x509TrustManager;
    }

    public static void resetLocalTrustStore() {
        x509TrustManager = null;
    }

    public boolean allowCertificate(X509Certificate[] certificateChain) {
        block7: {
            if (this.listener != null) {
                this.listener.getLogger().println("Auth - allowCertificate with incoming chain of len  " + certificateChain.length);
            }
            if (this.skipTls) {
                if (this.listener != null) {
                    this.listener.getLogger().println("Auth - in skip tls mode, returning true");
                }
                return true;
            }
            if (x509TrustManager != null) {
                try {
                    x509TrustManager.checkServerTrusted(certificateChain, "RSA");
                    if (this.listener != null) {
                        this.listener.getLogger().println("Auth - local trust mgr check server passed");
                    }
                    return true;
                }
                catch (Throwable t) {
                    if (this.listener == null) break block7;
                    t.printStackTrace(this.listener.getLogger());
                }
            }
        }
        return false;
    }

    public boolean allowHostname(String hostname, SSLSession sslSession) {
        if (this.listener != null) {
            this.listener.getLogger().println("Auth - allowHostname getting called, skip tls is " + this.skipTls);
        }
        if (this.skipTls) {
            return true;
        }
        LOGGER.info("allowHostname getting called but we are not skipping tls; returning false; investigate openshift-restclient-java and okhttp3");
        return false;
    }

    public boolean useCert() {
        return this.certs != null && this.certs.size() > 0 && !this.skipTls;
    }

    public Collection<X509Certificate> getCerts() {
        return this.certs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String pullTokenFromFile(File f, TaskListener listener) {
        FileInputStream fis = null;
        String authToken = null;
        boolean verbose = listener != null;
        try {
            fis = new FileInputStream(f);
            ArrayList<Integer> al = new ArrayList<Integer>();
            int rawbyte = -1;
            while ((rawbyte = fis.read()) != -1) {
                al.add(rawbyte);
            }
            byte[] buf = new byte[al.size()];
            for (int i = 0; i < al.size(); ++i) {
                buf[i] = (byte)((Integer)al.get(i)).intValue();
            }
            Class<Auth> clazz = Auth.class;
            synchronized (Auth.class) {
                if (authToken == null || authToken.length() == 0) {
                    authToken = new String(buf);
                }
                // ** MonitorExit[var8_14] (shouldn't be in output)
            }
        }
        catch (FileNotFoundException e) {
            if (verbose) {
                e.printStackTrace(listener.getLogger());
            }
        }
        catch (IOException e) {
            if (verbose) {
                e.printStackTrace(listener.getLogger());
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable e) {}
        }
        {
            return authToken;
        }
    }

    public static String deriveBearerToken(String at, TaskListener listener, boolean verbose, Map<String, String> env) {
        if (listener == null) {
            verbose = false;
        }
        String authToken = at;
        if (verbose) {
            listener.getLogger().println("\n\n");
        }
        if (authToken == null) {
            if (verbose) {
                listener.getLogger().println("Auth authToken null");
            }
        } else if (verbose) {
            listener.getLogger().println("Auth authToken len " + authToken.length());
        }
        if (authToken == null || authToken.length() == 0) {
            if (env != null && (authToken = env.get("AUTH_TOKEN")) != null && authToken.length() > 0) {
                File f;
                if (verbose) {
                    listener.getLogger().println("Auth token from global env vars " + authToken);
                }
                if ((f = new File(authToken)).exists()) {
                    if (verbose) {
                        listener.getLogger().println("Auth file exists " + f.getAbsolutePath());
                    }
                    authToken = Auth.pullTokenFromFile(f, listener);
                }
                return authToken;
            }
            File f = new File(AUTH_FILE);
            if (verbose) {
                listener.getLogger().println("Auth opened file object " + f);
            }
            if (f.exists()) {
                if (verbose) {
                    listener.getLogger().println("Auth file exists " + f.getAbsolutePath());
                }
                authToken = Auth.pullTokenFromFile(f, listener);
            } else if (verbose) {
                listener.getLogger().println("Auth file for auth token " + f.toString() + " does not exist");
            }
        }
        return authToken;
    }

    private static InputStream getInputStreamFromDataOrFile(String data, File file) throws FileNotFoundException, UnsupportedEncodingException {
        if (data != null) {
            return new ByteArrayInputStream(data.getBytes());
        }
        if (file != null) {
            return new FileInputStream(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<X509Certificate> createCert(File caCertFile, String certString, TaskListener listener, String apiURL) throws Exception {
        if (listener != null && certString != null) {
            listener.getLogger().println("Auth - using user inputted cert string");
        }
        try (InputStream pemInputStream = null;){
            pemInputStream = Auth.getInputStreamFromDataOrFile(certString, caCertFile);
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            Collection<? extends Certificate> collection = certFactory.generateCertificates(pemInputStream);
            return collection;
        }
    }
}

