package com.guagua.guagua.image.view

import android.content.Context
import android.graphics.Canvas
import android.graphics.Path
import android.graphics.RectF
import android.util.AttributeSet
import android.widget.ImageView

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 18:26
 * Version: 1.0.0
 * Description: 圆角图片
 * History:
 * <author> <time> <version> <desc>
 */
class RoundImageView @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) :
    ImageView(context, attrs, defStyleAttr) {

    private var radius = 8

    fun setRadius(radius: Int) {
        this.radius = radius
    }

    override fun onDraw(canvas: Canvas) {
        val path = Path()
        path.addRoundRect(
            RectF(0f, 0f, width.toFloat(), height.toFloat()),
            dp2px(context, radius).toFloat(),
            dp2px(
                context, radius
            ).toFloat(),
            Path.Direction.CW
        )
        canvas.clipPath(path)//设置可显示的区域，canvas四个角会被剪裁掉
        super.onDraw(canvas)
    }

    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        super.onMeasure(widthMeasureSpec, widthMeasureSpec)
    }

    private fun dp2px(context: Context, dp: Int): Int {
        return (dp * context.resources.displayMetrics.density).toInt()
    }
}