package com.guagua.guagua.image.utils

import android.view.View
import java.util.HashMap

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 17:01
 * Version: 1.0.0
 * Description: 防爆点击辅助类
 * History:
 * <author> <time> <version> <desc>
 */
class FastClickChecker {
    var viewTimeHashMap = HashMap<View, Long>()
    var idTimeHashMap = HashMap<Int, Long>()
    private var timeSpan = 500

    constructor() {
    }

    constructor(timeSpan: Int) {
        this.timeSpan = timeSpan
    }

    //设置需要监听的id
    fun setView(vararg viewIds: Int) {
        for (id in viewIds) {
            idTimeHashMap[id] = 0L
        }
    }

    //设置需要监听的view
    fun setView(vararg views: View) {
        for (v in views) {
            viewTimeHashMap[v] = 0L
        }
    }

    //检查是否是快速点击
    fun isFastClick(view: View): Boolean {
        if (viewTimeHashMap.containsKey(view)) {
            val lastClickTime = viewTimeHashMap[view]
            val time = System.currentTimeMillis()
            val span = time - lastClickTime!!
            if (0 < span && span < timeSpan) {
                return true
            }
            viewTimeHashMap[view] = time
        }
        return false
    }

    //检查是否是快速点击
    fun isFastClick(viewId: Int): Boolean {
        if (idTimeHashMap.containsKey(viewId)) {
            val lastClickTime = idTimeHashMap[viewId]
            val time = System.currentTimeMillis()
            val span = time - lastClickTime!!
            if (0 < span && span < timeSpan) {
                return true
            }
            idTimeHashMap[viewId] = time
        }
        return false
    }

    //设置认定为快速点击的时间间隔
    fun setTimeSpan(span: Int) {
        this.timeSpan = span
    }
}
