package com.guagua.guagua.image.utils

import com.guagua.guagua.image.data.MediaFile
import java.util.ArrayList

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/28 16:53
 * Version: 1.0.0
 * Description:  * 数据保存类
 * （随着Android版本的提高，对Intent传递数据的大小也做了不同的限制，在一些高版本或者低配机型上可能会发生
 * android.os.TransactionTooLargeException: data parcel size xxxx bytes异常，故用此方案适配）
 * History:
 * <author> <time> <version> <desc>
 */
class DataUtil private constructor() {
    private var mData: List<MediaFile> = ArrayList()

    companion object {
        @Volatile
        private var mDataUtilInstance: DataUtil? = null

        val instance: DataUtil?
            get() {
                if (mDataUtilInstance == null) {
                    synchronized(DataUtil::class.java) {
                        if (mDataUtilInstance == null) {
                            mDataUtilInstance = DataUtil()
                        }
                    }
                }
                return mDataUtilInstance
            }
    }

    fun getMediaData(): List<MediaFile> {
        return mData
    }

    fun setMediaData(data: List<MediaFile>) {
        this.mData = data
    }
}