package com.guagua.guagua.image.task

import android.content.Context
import android.util.Log
import com.guagua.guagua.image.data.MediaFile
import com.guagua.guagua.image.listener.MediaLoadCallback
import com.guagua.guagua.image.loader.ImageScanner
import com.guagua.guagua.image.loader.MediaHandler
import java.util.ArrayList

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 20:02
 * Version: 1.0.0
 * Description: 图片扫描器
 * History:
 * <author> <time> <version> <desc>
 */
class ImageLoadTask(context: Context, mediaLoadCallback: MediaLoadCallback): Runnable {

    private val mContext: Context
    private val mImageScanner: ImageScanner?
    private val mMediaLoadCallback: MediaLoadCallback?

    init {
        mContext = context
        mImageScanner = ImageScanner(mContext)
        mMediaLoadCallback = mediaLoadCallback
    }

    override fun run() {
        //存放所有照片
        var imageFileList = ArrayList<MediaFile>()

        if (mImageScanner != null) {
            imageFileList = mImageScanner.queryMedia()
        }
        Log.e("ImageLoadTask", "run()==================" + imageFileList.size)
        mMediaLoadCallback?.loadMediaSuccess(MediaHandler.getImageFolder(mContext, imageFileList))
    }

}