package com.guagua.guagua.image.manager

import com.guagua.guagua.image.utils.MediaFileUtil
import java.util.ArrayList
import java.util.HashMap

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 14:51
 * Version: 1.0.0
 * Description: 媒体选择集合管理类
 * History:
 * <author> <time> <version> <desc>
 */

object SelectionManager {
    private val mSelectImagePaths = ArrayList<String>()
    private val mSelectImageDurations = ArrayList<HashMap<String, String>>()

    private var mMaxCount = 1

    /**
     * 设置最大选择数
     *
     * @param maxCount
     */
    fun setMaxCount(maxCount: Int) {
        this.mMaxCount = maxCount
    }

    /**
     * 获取当前设置最大选择数
     *
     * @return
     */
    fun getMaxCount(): Int = this.mMaxCount

    /**
     * 获取当前所选图片集合path
     *
     * @return
     */
    fun getSelectPaths(): ArrayList<String> = mSelectImagePaths

    fun getmSelectImageDurations(): ArrayList<HashMap<String, String>> = mSelectImageDurations

    /**
     * 添加/移除图片到选择集合
     *
     * @param imagePath
     * @return
     */
    fun addImageToSelectList(imagePath: String): Boolean {
        return if (mSelectImagePaths.contains(imagePath)) {
            mSelectImagePaths.remove(imagePath)
        } else {
            if (mSelectImagePaths.size < mMaxCount) {
                mSelectImagePaths.add(imagePath)
            } else {
                false
            }
        }
    }

    /**
     * 添加视频时长
     */
    fun addImageDurationToSelectList(imagePath: String, duration: Long): Boolean {
        if (mSelectImagePaths.contains(imagePath)) {
            for (i in mSelectImagePaths.indices) {
                if (mSelectImagePaths[i] == imagePath) {
                    mSelectImageDurations.removeAt(i)
                }
            }
            return mSelectImagePaths.remove(imagePath)
        } else {
            if (mSelectImagePaths.size < mMaxCount) {
                val map = HashMap<String, String>()
                map[imagePath] = (duration / 1000).toString()
                mSelectImageDurations.add(map)
                return mSelectImagePaths.add(imagePath)
            }
        }
        return false
    }

    /**
     * 添加图片到选择集合 如果前个页面已经选择过了
     *
     * @param imagePaths
     */
    fun addImagePathsToSelectList(imagePaths: List<String>?) {
        if (imagePaths != null) {
            if (imagePaths.isEmpty()) {
                mSelectImagePaths.clear()
                mSelectImageDurations.clear()
                return
            }
            for (i in imagePaths.indices) {
                val imagePath = imagePaths[i]
                if (!mSelectImagePaths.contains(imagePath) && mSelectImagePaths.size < mMaxCount) {
                    mSelectImagePaths.add(imagePath)
                }
            }
        } else {
            mSelectImagePaths.clear()
            mSelectImageDurations.clear()
        }
    }

    /**
     * 判断当前图片是否被选择
     *
     * @param imagePath
     * @return
     */
    fun isImageSelect(imagePath: String?): Boolean {
        if (null != imagePath) {
            return mSelectImagePaths.contains(imagePath)
        }
        return false
    }

    fun indexOf(imagePath: String?): Int {
        return if (null == imagePath || imagePath.length < 0)
            -1
        else
            mSelectImagePaths.indexOf(imagePath) + 1
    }

    /**
     * 是否还可以继续选择图片
     *
     * @return
     */
    fun isCanChoose(): Boolean {
        return if (getSelectPaths().size < mMaxCount) {
            true
        } else false
    }

    /**
     * 是否可以添加到选择集合（在singleType模式下，图片视频不能一起选）
     *
     * @param currentPath
     * @param filePath
     * @return
     */
    fun isCanAddSelectionPaths(currentPath: String, filePath: String): Boolean {
        return if (MediaFileUtil.isVideoFileType(currentPath) && !MediaFileUtil.isVideoFileType(
                filePath
            ) || !MediaFileUtil.isVideoFileType(currentPath) && MediaFileUtil.isVideoFileType(
                filePath
            )
        ) {
            false
        } else true
    }

    /**
     * 清除已选图片
     */
    fun removeAll() {
        mSelectImagePaths.clear()
    }

    /**
     * 清除已选图片
     */
    fun removeAllDuration() {
        mSelectImageDurations.clear()
    }

}