package com.guagua.guagua.image.loader

import android.content.Context
import android.database.Cursor
import android.net.Uri
import android.provider.MediaStore
import com.guagua.guagua.image.data.MediaFile
import com.guagua.guagua.image.manager.ConfigManager

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 20:18
 * Version: 1.0.0
 * Description: 视频扫描类
 * History:
 * <author> <time> <version> <desc>
 */
class VideoScanner(context: Context): AbsMediaScanner<MediaFile>(context) {

    override fun getScanUri(): Uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI

    override fun getProjection(): Array<String> = arrayOf(
        MediaStore.Video.Media.DATA,
        MediaStore.Video.Media.MIME_TYPE,
        MediaStore.Video.Media.BUCKET_ID,
        MediaStore.Video.Media.BUCKET_DISPLAY_NAME,
        MediaStore.Video.Media.DURATION,
        MediaStore.Video.Media.DATE_TAKEN,
        MediaStore.Video.Media.DATE_ADDED,
        MediaStore.Video.Media._ID
    )

    override fun getSelection(): String? = null

    override fun getSelectionArgs(): Array<String>? = null

    override fun getOrder(): String = MediaStore.Images.Media.DATE_ADDED + " desc"

    override fun parse(cursor: Cursor): MediaFile {
        val path = cursor.getString(cursor.getColumnIndex(MediaStore.Images.Media.DATA))
        val mime = cursor.getString(cursor.getColumnIndex(MediaStore.Images.Media.MIME_TYPE))
        val folderId = cursor.getInt(cursor.getColumnIndex(MediaStore.Images.Media.BUCKET_ID))
        val folderName = cursor.getString(cursor.getColumnIndex(MediaStore.Images.Media.BUCKET_DISPLAY_NAME))
        val duration = cursor.getLong(cursor.getColumnIndex(MediaStore.Video.Media.DURATION))
        val dateToken = cursor.getLong(cursor.getColumnIndex(MediaStore.Images.Media.DATE_TAKEN))
        val dateAdded = cursor.getString(cursor.getColumnIndex(MediaStore.Images.Media.DATE_ADDED))
        return MediaFile(path = path, mime = mime, folderId = folderId, folderName = folderName, duration = duration, dateToken = dateToken, dateAdded = dateAdded)
    }

}