package com.guagua.guagua.image.executors

import android.util.Log
import java.util.concurrent.ExecutorService
import java.util.concurrent.Executors

/**
 * Copyright (C), 2020-2020, guagua
 * Author: lixiangchao
 * Date: 2020/4/27 19:56
 * Version: 1.0.0
 * Description: 扫描线程池
 * History:
 * <author> <time> <version> <desc>
 */
class CommonExecutor private constructor() {
    private val mExecutorService: ExecutorService

    init {
        mExecutorService = Executors.newCachedThreadPool { runnable ->
            val thread = Thread(runnable)
            thread.name = "CommonExecutor"
            thread
        }
    }


    fun execute(runnable: Runnable) {
        Log.e("ImagePickerActivity", "execute()==============" + (runnable == null))
        mExecutorService.execute(runnable)
    }

    companion object {
        @Volatile
        private var mCommonExecutor: CommonExecutor? = null
        val instance: CommonExecutor?
            get() {
                if (mCommonExecutor == null) {
                    synchronized(CommonExecutor::class.java) {
                        if (mCommonExecutor == null) {
                            mCommonExecutor = CommonExecutor()
                        }
                    }
                }
                return mCommonExecutor
            }
    }
}