/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.svgsupport;

import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.UserAgent;
import org.w3c.dom.Document;

public class OpenHtmlDocumentLoader
extends DocumentLoader {
    private final UserAgentCallback userAgentCallback;

    public OpenHtmlDocumentLoader(UserAgent userAgent, UserAgentCallback userAgentCallback) {
        super(userAgent);
        this.userAgentCallback = userAgentCallback;
    }

    public Document loadDocument(String uri) throws IOException {
        try {
            URI parsedURI = new URI(uri);
            if ("file".equals(parsedURI.getScheme()) && parsedURI.getPath() == null && parsedURI.getSchemeSpecificPart() != null) {
                uri = this.userAgentCallback.resolveURI(parsedURI.getSchemeSpecificPart());
            } else if (!parsedURI.isAbsolute()) {
                uri = this.userAgentCallback.resolveURI(uri);
            }
        }
        catch (URISyntaxException uriSyntaxException) {
            XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.EXCEPTION_URI_SYNTAX_WHILE_LOADING_EXTERNAL_SVG_RESOURCE, (Object)uri, (Throwable)uriSyntaxException);
        }
        return super.loadDocument(uri, (InputStream)new ByteArrayInputStream(this.userAgentCallback.getBinaryResource(uri)));
    }
}

