/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.svgsupport;

import com.openhtmltopdf.css.sheet.FontFaceRule;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.svgsupport.BatikSVGImage;
import com.openhtmltopdf.svgsupport.PDFTranscoder;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Element;

public class BatikSVGDrawer
implements SVGDrawer {
    public PDFTranscoder.OpenHtmlFontResolver fontResolver;
    private final boolean allowScripts;
    private final boolean allowExternalResources;

    public BatikSVGDrawer(SvgScriptMode scriptMode, SvgExternalResourceMode externalResourceMode) {
        this.allowScripts = scriptMode == SvgScriptMode.INSECURE_ALLOW_SCRIPTS;
        this.allowExternalResources = externalResourceMode == SvgExternalResourceMode.INSECURE_ALLOW_EXTERNAL_RESOURCE_REQUESTS;
    }

    public BatikSVGDrawer() {
        this(SvgScriptMode.SECURE, SvgExternalResourceMode.SECURE);
    }

    public void importFontFaceRules(List<FontFaceRule> fontFaces, SharedContext shared) {
        this.fontResolver = new PDFTranscoder.OpenHtmlFontResolver();
        this.fontResolver.importFontFaces(fontFaces, shared);
    }

    public SVGDrawer.SVGImage buildSVGImage(Element svgElement, Box box, CssContext c, double cssWidth, double cssHeight, double dotsPerPixel) {
        double cssMaxWidth = CalculatedStyle.getCSSMaxWidth((CssContext)c, (Box)box);
        double cssMaxHeight = CalculatedStyle.getCSSMaxHeight((CssContext)c, (Box)box);
        BatikSVGImage img = new BatikSVGImage(svgElement, box, cssWidth, cssHeight, cssMaxWidth, cssMaxHeight, dotsPerPixel);
        img.setFontResolver(this.fontResolver);
        img.setSecurityOptions(this.allowScripts, this.allowExternalResources);
        return img;
    }

    public void close() throws IOException {
    }

    public static enum SvgScriptMode {
        SECURE,
        INSECURE_ALLOW_SCRIPTS;

    }

    public static enum SvgExternalResourceMode {
        SECURE,
        INSECURE_ALLOW_EXTERNAL_RESOURCE_REQUESTS;

    }
}

