/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.svgsupport;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.sheet.FontFaceRule;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.FSDerivedValue;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.svgsupport.OpenHtmlGvtFontFamily;
import com.openhtmltopdf.svgsupport.OpenHtmlUserAgent;
import com.openhtmltopdf.svgsupport.PDFGraphics2DOutputDeviceAdapter;
import com.openhtmltopdf.util.XRLog;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.batik.bridge.FontFace;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.transcoder.ErrorHandler;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.w3c.dom.Document;

public class PDFTranscoder
extends SVGAbstractTranscoder {
    private final PDFGraphics2DOutputDeviceAdapter od;
    private final OpenHtmlFontResolver fontResolver;

    public PDFTranscoder(OutputDevice od, RenderingContext ctx, double x, double y, OpenHtmlFontResolver fontResolver, float dotsPerInch) {
        this.od = new PDFGraphics2DOutputDeviceAdapter(ctx, od, x, y, dotsPerInch);
        this.fontResolver = fontResolver;
    }

    protected void transcode(Document svg, String uri, TranscoderOutput out) throws TranscoderException {
        this.userAgent = new OpenHtmlUserAgent(this.fontResolver);
        super.transcode(svg, uri, out);
        this.root.paint((Graphics2D)((Object)this.od));
    }

    public ErrorHandler getErrorHandler() {
        return new ErrorHandler(){

            public void warning(TranscoderException arg0) throws TranscoderException {
                XRLog.exception((String)"SVG WARN", (Throwable)arg0);
            }

            public void fatalError(TranscoderException arg0) throws TranscoderException {
                XRLog.exception((String)"SVG FATAL", (Throwable)arg0);
            }

            public void error(TranscoderException arg0) throws TranscoderException {
                XRLog.exception((String)"SVG ERROR", (Throwable)arg0);
            }
        };
    }

    public static class OpenHtmlFontResolver
    implements FontFamilyResolver {
        private final Map<String, OpenHtmlGvtFontFamily> families = new HashMap<String, OpenHtmlGvtFontFamily>(4);

        public GVTFontFamily resolve(String arg0, FontFace arg1) {
            return null;
        }

        public GVTFontFamily resolve(String family) {
            if (this.families.containsKey(family)) {
                return this.families.get(family);
            }
            return null;
        }

        public GVTFontFamily loadFont(InputStream arg0, FontFace arg1) throws Exception {
            return null;
        }

        public GVTFontFamily getFamilyThatCanDisplay(char arg0) {
            return null;
        }

        public GVTFontFamily getDefault() {
            return null;
        }

        private Float getStyle(IdentValue fontStyle) {
            if (fontStyle == IdentValue.ITALIC || fontStyle == IdentValue.OBLIQUE) {
                return TextAttribute.POSTURE_OBLIQUE;
            }
            return null;
        }

        private Float getWeight(IdentValue weight) {
            if (weight == IdentValue.NORMAL) {
                return TextAttribute.WEIGHT_REGULAR;
            }
            if (weight == IdentValue.BOLD) {
                return TextAttribute.WEIGHT_BOLD;
            }
            if (weight == IdentValue.FONT_WEIGHT_100) {
                return TextAttribute.WEIGHT_EXTRA_LIGHT;
            }
            if (weight == IdentValue.FONT_WEIGHT_200) {
                return TextAttribute.WEIGHT_LIGHT;
            }
            if (weight == IdentValue.FONT_WEIGHT_300) {
                return TextAttribute.WEIGHT_LIGHT;
            }
            if (weight == IdentValue.FONT_WEIGHT_400) {
                return TextAttribute.WEIGHT_MEDIUM;
            }
            if (weight == IdentValue.FONT_WEIGHT_500) {
                return TextAttribute.WEIGHT_SEMIBOLD;
            }
            if (weight == IdentValue.FONT_WEIGHT_600) {
                return TextAttribute.WEIGHT_SEMIBOLD;
            }
            if (weight == IdentValue.FONT_WEIGHT_700) {
                return TextAttribute.WEIGHT_BOLD;
            }
            if (weight == IdentValue.FONT_WEIGHT_800) {
                return TextAttribute.WEIGHT_EXTRABOLD;
            }
            if (weight == IdentValue.FONT_WEIGHT_900) {
                return TextAttribute.WEIGHT_ULTRABOLD;
            }
            if (weight == IdentValue.LIGHTER) {
                return TextAttribute.WEIGHT_MEDIUM;
            }
            if (weight == IdentValue.BOLDER) {
                return TextAttribute.WEIGHT_MEDIUM;
            }
            return null;
        }

        private void addFontFaceFont(String fontFamilyNameOverride, IdentValue fontWeightOverride, IdentValue fontStyleOverride, String uri, byte[] font1) throws FontFormatException {
            OpenHtmlGvtFontFamily family = null;
            if (this.families.containsKey(fontFamilyNameOverride)) {
                family = this.families.get(fontFamilyNameOverride);
            } else {
                family = new OpenHtmlGvtFontFamily(fontFamilyNameOverride);
                this.families.put(fontFamilyNameOverride, family);
            }
            family.addFont(font1, 1.0f, this.getWeight(fontWeightOverride), this.getStyle(fontStyleOverride));
        }

        public void importFontFaces(List<FontFaceRule> fontFaces, SharedContext ctx) {
            for (FontFaceRule rule : fontFaces) {
                CalculatedStyle style = rule.getCalculatedStyle();
                FSDerivedValue src = style.valueByName(CSSName.SRC);
                if (src == IdentValue.NONE) continue;
                byte[] font1 = ctx.getUac().getBinaryResource(src.asString());
                if (font1 == null) {
                    XRLog.exception((String)("Could not load font " + src.asString()));
                    continue;
                }
                String fontFamily = null;
                IdentValue fontWeight = null;
                IdentValue fontStyle = null;
                if (rule.hasFontFamily()) {
                    fontFamily = style.valueByName(CSSName.FONT_FAMILY).asString();
                }
                if (rule.hasFontWeight()) {
                    fontWeight = style.getIdent(CSSName.FONT_WEIGHT);
                }
                if (rule.hasFontStyle()) {
                    fontStyle = style.getIdent(CSSName.FONT_STYLE);
                }
                try {
                    this.addFontFaceFont(fontFamily, fontWeight, fontStyle, src.asString(), font1);
                }
                catch (FontFormatException e) {
                    XRLog.exception((String)"Couldn't read font", (Throwable)e);
                }
            }
        }
    }
}

