/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.java2d.api;

import com.openhtmltopdf.java2d.api.FSPage;
import com.openhtmltopdf.java2d.api.FSPageProcessor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class BufferedImagePageProcessor
implements FSPageProcessor {
    private final double _scale;
    private final int _imageType;
    private List<BufferedImagePage> _pages = new ArrayList<BufferedImagePage>();

    public BufferedImagePageProcessor(int imageType, double scale) {
        this._imageType = imageType;
        this._scale = scale;
    }

    @Override
    public FSPage createPage(int zeroBasedPageNumber, int width, int height) {
        BufferedImage image = new BufferedImage((int)((double)width * this._scale), (int)((double)height * this._scale), this._imageType);
        BufferedImagePage bufferedImagePage = new BufferedImagePage(image);
        this._pages.add(bufferedImagePage);
        return bufferedImagePage;
    }

    @Override
    public void finishPage(FSPage pg) {
    }

    public List<BufferedImage> getPageImages() {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        for (BufferedImagePage page : this._pages) {
            images.add(page._image);
        }
        return images;
    }

    private class BufferedImagePage
    implements FSPage {
        BufferedImage _image;

        BufferedImagePage(BufferedImage image) {
            this._image = image;
        }

        @Override
        public Graphics2D getGraphics() {
            Graphics2D graphics = this._image.createGraphics();
            if (this._image.getColorModel().hasAlpha()) {
                graphics.clearRect(0, 0, this._image.getWidth(), this._image.getHeight());
            } else {
                graphics.setColor(Color.WHITE);
                graphics.fillRect(0, 0, this._image.getWidth(), this._image.getHeight());
            }
            graphics.scale(BufferedImagePageProcessor.this._scale, BufferedImagePageProcessor.this._scale);
            return graphics;
        }
    }
}

