/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.java2d;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.BidiSplitterFactory;
import com.openhtmltopdf.bidi.SimpleBidiReorderer;
import com.openhtmltopdf.context.StyleReference;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.FSCache;
import com.openhtmltopdf.extend.FSDOMMutator;
import com.openhtmltopdf.extend.FSObjectDrawerFactory;
import com.openhtmltopdf.extend.FSUriResolver;
import com.openhtmltopdf.extend.FontContext;
import com.openhtmltopdf.extend.FontResolver;
import com.openhtmltopdf.extend.HttpStreamFactory;
import com.openhtmltopdf.extend.NamespaceHandler;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.ReplacedElementFactory;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.extend.TextRenderer;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.extend.UserInterface;
import com.openhtmltopdf.java2d.Java2DFontContext;
import com.openhtmltopdf.java2d.Java2DFontResolver;
import com.openhtmltopdf.java2d.Java2DOutputDevice;
import com.openhtmltopdf.java2d.Java2DReplacedElementFactory;
import com.openhtmltopdf.java2d.Java2DTextRenderer;
import com.openhtmltopdf.java2d.api.FSPage;
import com.openhtmltopdf.java2d.api.FSPageProcessor;
import com.openhtmltopdf.java2d.api.IJava2DRenderer;
import com.openhtmltopdf.layout.BoxBuilder;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.outputdevice.helper.BaseDocument;
import com.openhtmltopdf.outputdevice.helper.NullUserInterface;
import com.openhtmltopdf.outputdevice.helper.PageDimensions;
import com.openhtmltopdf.outputdevice.helper.UnicodeImplementation;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.ViewportBox;
import com.openhtmltopdf.resource.XMLResource;
import com.openhtmltopdf.simple.extend.XhtmlNamespaceHandler;
import com.openhtmltopdf.swing.NaiveUserAgent;
import com.openhtmltopdf.util.Configuration;
import com.openhtmltopdf.util.ThreadCtx;
import com.openhtmltopdf.util.XRLog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class Java2DRenderer
implements IJava2DRenderer,
Closeable {
    private final List<FSDOMMutator> _domMutators;
    private final SVGDrawer _mathMLImpl;
    private BlockBox _root;
    private final SharedContext _sharedContext;
    private final Java2DOutputDevice _outputDevice;
    private BidiSplitterFactory _splitterFactory;
    private byte _defaultTextDirection = 0;
    private BidiReorderer _reorderer;
    private final SVGDrawer _svgImpl;
    private Document _doc;
    private final FSObjectDrawerFactory _objectDrawerFactory;
    private final FSPageProcessor _pageProcessor;
    private static final int DEFAULT_DOTS_PER_PIXEL = 1;
    private static final int DEFAULT_DPI = 72;
    private final int _initialPageNo;
    private final short _pagingMode;

    public Java2DRenderer(BaseDocument doc, UnicodeImplementation unicode, HttpStreamFactory httpStreamFactory, FSUriResolver resolver, FSCache cache, SVGDrawer _svgImpl, SVGDrawer _mathMLImpl, PageDimensions pageSize, String replacementText, boolean testMode, FSPageProcessor pageProcessor, Graphics2D layoutGraphics, int initialPageNumber, short pagingMode, FSObjectDrawerFactory objectDrawerFactory, String preferredTransformerFactoryImplementationClass, String preferredDocumentBuilderFactoryImplementationClass, List<FSDOMMutator> _domMutators) {
        this._pagingMode = pagingMode;
        this._pageProcessor = pageProcessor;
        this._initialPageNo = initialPageNumber;
        this._svgImpl = _svgImpl;
        this._mathMLImpl = _mathMLImpl;
        this._domMutators = _domMutators;
        this._objectDrawerFactory = objectDrawerFactory;
        this._outputDevice = new Java2DOutputDevice(layoutGraphics);
        NaiveUserAgent uac = new NaiveUserAgent();
        if (httpStreamFactory != null) {
            uac.setHttpStreamFactory(httpStreamFactory);
        }
        if (resolver != null) {
            uac.setUriResolver(resolver);
        }
        if (cache != null) {
            uac.setExternalCache(cache);
        }
        this._sharedContext = new SharedContext();
        this._sharedContext.registerWithThread();
        this._sharedContext._preferredTransformerFactoryImplementationClass = preferredTransformerFactoryImplementationClass;
        this._sharedContext._preferredDocumentBuilderFactoryImplementationClass = preferredDocumentBuilderFactoryImplementationClass;
        this._sharedContext.setUserAgentCallback((UserAgentCallback)uac);
        this._sharedContext.setCss(new StyleReference((UserAgentCallback)uac));
        Java2DFontResolver fontResolver = new Java2DFontResolver(this._sharedContext);
        this._sharedContext.setFontResolver((FontResolver)fontResolver);
        Java2DReplacedElementFactory replacedFactory = new Java2DReplacedElementFactory(this._svgImpl, this._objectDrawerFactory, this._mathMLImpl);
        this._sharedContext.setReplacedElementFactory((ReplacedElementFactory)replacedFactory);
        this._sharedContext.setTextRenderer((TextRenderer)new Java2DTextRenderer());
        this._sharedContext.setDPI(72.0f);
        this._sharedContext.setDotsPerPixel(1);
        this._sharedContext.setPrint(true);
        this._sharedContext.setInteractive(false);
        this._sharedContext.setDefaultPageSize(pageSize.w, pageSize.h, pageSize.isSizeInches);
        if (replacementText != null) {
            this._sharedContext.setReplacementText(replacementText);
        }
        if (unicode.splitterFactory != null) {
            this._splitterFactory = unicode.splitterFactory;
        }
        if (unicode.reorderer != null) {
            this._reorderer = unicode.reorderer;
            this._outputDevice.setBidiReorderer(this._reorderer);
        }
        if (unicode.lineBreaker != null) {
            this._sharedContext.setLineBreaker(unicode.lineBreaker);
        }
        if (unicode.charBreaker != null) {
            this._sharedContext.setCharacterBreaker(unicode.charBreaker);
        }
        if (unicode.toLowerTransformer != null) {
            this._sharedContext.setUnicodeToLowerTransformer(unicode.toLowerTransformer);
        }
        if (unicode.toUpperTransformer != null) {
            this._sharedContext.setUnicodeToUpperTransformer(unicode.toUpperTransformer);
        }
        if (unicode.toTitleTransformer != null) {
            this._sharedContext.setUnicodeToTitleTransformer(unicode.toTitleTransformer);
        }
        byte by = this._defaultTextDirection = unicode.textDirection ? (byte)1 : 0;
        if (doc.html != null) {
            this.setDocumentFromString(doc.html, doc.baseUri);
        } else if (doc.document != null) {
            this.setDocument(doc.document, doc.baseUri);
        } else if (doc.uri != null) {
            this.setDocument(doc.uri);
        } else if (doc.file != null) {
            try {
                this.setDocument(doc.file);
            }
            catch (IOException e) {
                XRLog.exception((String)"Problem trying to read input XHTML file", (Throwable)e);
                throw new RuntimeException("File IO problem", e);
            }
        }
    }

    private void setDocumentFromString(String content, String baseUrl) {
        InputSource is = new InputSource(new BufferedReader(new StringReader(content)));
        Document dom = XMLResource.load((InputSource)is).getDocument();
        this.setDocument(dom, baseUrl);
    }

    private void setDocument(Document doc, String url) {
        this.setDocument(doc, url, (NamespaceHandler)new XhtmlNamespaceHandler());
    }

    private void setDocument(File file) throws IOException {
        File parent = file.getAbsoluteFile().getParentFile();
        this.setDocument(this.loadDocument(file.toURI().toURL().toExternalForm()), parent == null ? "" : parent.toURI().toURL().toExternalForm());
    }

    private void setDocument(String uri) {
        this.setDocument(this.loadDocument(uri), uri);
    }

    private Document loadDocument(String uri) {
        return this._sharedContext.getUserAgentCallback().getXMLResource(uri).getDocument();
    }

    private void setDocument(Document doc, String url, NamespaceHandler nsh) {
        this._doc = doc;
        for (FSDOMMutator domMutator : this._domMutators) {
            domMutator.mutateDocument(doc);
        }
        this._sharedContext.reset();
        if (Configuration.isTrue((String)"xr.cache.stylesheets", (boolean)true)) {
            this._sharedContext.getCss().flushStyleSheets();
        } else {
            this._sharedContext.getCss().flushAllStyleSheets();
        }
        this._sharedContext.setBaseURL(url);
        this._sharedContext.setNamespaceHandler(nsh);
        this._sharedContext.getCss().setDocumentContext(this._sharedContext, this._sharedContext.getNamespaceHandler(), doc, (UserInterface)new NullUserInterface());
        this.getFontResolver().importFontFaces(this._sharedContext.getCss().getFontFaceRules());
        if (this._svgImpl != null) {
            this._svgImpl.importFontFaceRules(this._sharedContext.getCss().getFontFaceRules(), this._sharedContext);
        }
        if (this._mathMLImpl != null) {
            this._mathMLImpl.importFontFaceRules(this._sharedContext.getCss().getFontFaceRules(), this._sharedContext);
        }
    }

    public Java2DFontResolver getFontResolver() {
        return (Java2DFontResolver)this._sharedContext.getFontResolver();
    }

    public void layout() {
        LayoutContext c = this.newLayoutContext();
        BlockBox root = BoxBuilder.createRootBox((LayoutContext)c, (Document)this._doc);
        root.setContainingBlock((Box)new ViewportBox(this.getInitialExtents(c)));
        root.layout(c);
        Dimension dim = root.getLayer().getPaintingDimension(c);
        root.getLayer().trimEmptyPages((CssContext)c, dim.height);
        root.getLayer().layoutPages(c);
        this._root = root;
    }

    private Rectangle getInitialExtents(LayoutContext c) {
        PageBox first = Layer.createPageBox((CssContext)c, (String)"first");
        return new Rectangle(0, 0, first.getContentWidth((CssContext)c), first.getContentHeight((CssContext)c));
    }

    private RenderingContext newRenderingContext() {
        RenderingContext result = this._sharedContext.newRenderingContextInstance();
        result.setFontContext((FontContext)new Java2DFontContext(this._outputDevice.getGraphics()));
        result.setOutputDevice((OutputDevice)this._outputDevice);
        if (this._reorderer != null) {
            result.setBidiReorderer(this._reorderer);
        }
        this._outputDevice.setRenderingContext(result);
        this._sharedContext.getTextRenderer().setup(result.getFontContext());
        result.setRootLayer(this._root.getLayer());
        return result;
    }

    private LayoutContext newLayoutContext() {
        LayoutContext result = this._sharedContext.newLayoutContextInstance();
        result.setFontContext((FontContext)new Java2DFontContext(this._outputDevice.getGraphics()));
        if (this._splitterFactory != null) {
            result.setBidiSplitterFactory(this._splitterFactory);
        }
        if (this._reorderer != null) {
            result.setBidiReorderer(this._reorderer);
        }
        result.setDefaultTextDirection(this._defaultTextDirection);
        ((Java2DTextRenderer)this._sharedContext.getTextRenderer()).setup(result.getFontContext(), (BidiReorderer)(this._reorderer != null ? this._reorderer : new SimpleBidiReorderer()));
        return result;
    }

    public void writePages() throws IOException {
        List pages = this._root.getLayer().getPages();
        RenderingContext c = this.newRenderingContext();
        c.setInitialPageNo(this._initialPageNo);
        PageBox firstPage = (PageBox)pages.get(0);
        Rectangle2D.Float firstPageSize = new Rectangle2D.Float(0.0f, 0.0f, firstPage.getWidth((CssContext)c) / 1, firstPage.getHeight((CssContext)c) / 1);
        this.writePageImages(pages, c, firstPageSize);
    }

    public void writePage(int zeroBasedPageNumber) throws IOException {
        List pages = this._root.getLayer().getPages();
        if (zeroBasedPageNumber >= pages.size()) {
            throw new IndexOutOfBoundsException();
        }
        RenderingContext c = this.newRenderingContext();
        c.setInitialPageNo(this._initialPageNo);
        PageBox page = (PageBox)pages.get(zeroBasedPageNumber);
        Rectangle2D.Float pageSize = new Rectangle2D.Float(0.0f, 0.0f, page.getWidth((CssContext)c) / 1, page.getHeight((CssContext)c) / 1);
        this._outputDevice.setRoot(this._root);
        FSPage pg = this._pageProcessor.createPage(zeroBasedPageNumber, (int)((RectangularShape)pageSize).getWidth(), (int)((RectangularShape)pageSize).getHeight());
        this._outputDevice.initializePage(pg.getGraphics());
        this._root.getLayer().assignPagePaintingPositions((CssContext)c, this._pagingMode);
        c.setPageCount(pages.size());
        c.setPage(zeroBasedPageNumber, page);
        this.paintPage(c, page);
        this._pageProcessor.finishPage(pg);
        this._outputDevice.finish(c, this._root);
    }

    public void writeSinglePage() {
        List pages = this._root.getLayer().getPages();
        RenderingContext c = this.newRenderingContext();
        c.setInitialPageNo(this._initialPageNo);
        PageBox page = (PageBox)pages.get(0);
        Rectangle2D.Float pageSize = new Rectangle2D.Float(0.0f, 0.0f, page.getWidth((CssContext)c) / 1, this._root.getHeight() / 1);
        this._outputDevice.setRoot(this._root);
        FSPage pg = this._pageProcessor.createPage(0, (int)((RectangularShape)pageSize).getWidth(), this._root.getHeight());
        this._outputDevice.initializePage(pg.getGraphics());
        this._root.getLayer().assignPagePaintingPositions((CssContext)c, this._pagingMode);
        c.setPageCount(pages.size());
        c.setPage(0, page);
        page.paintBackground(c, 0, this._pagingMode);
        page.paintMarginAreas(c, 0, this._pagingMode);
        page.paintBorder(c, 0, this._pagingMode);
        Shape working = this._outputDevice.getClip();
        this._root.getLayer().paint(c);
        this._outputDevice.setClip(working);
        this._pageProcessor.finishPage(pg);
        this._outputDevice.finish(c, this._root);
    }

    public int getPageCount() {
        return this._root.getLayer().getPages().size();
    }

    private void writePageImages(List<PageBox> pages, RenderingContext c, Rectangle2D firstPageSize) throws IOException {
        this._outputDevice.setRoot(this._root);
        FSPage pg = this._pageProcessor.createPage(0, (int)firstPageSize.getWidth(), (int)firstPageSize.getHeight());
        this._outputDevice.initializePage(pg.getGraphics());
        this._root.getLayer().assignPagePaintingPositions((CssContext)c, this._pagingMode);
        int pageCount = this._root.getLayer().getPages().size();
        c.setPageCount(pageCount);
        for (int i = 0; i < pageCount; ++i) {
            PageBox currentPage = pages.get(i);
            c.setPage(i, currentPage);
            this.paintPage(c, currentPage);
            this._pageProcessor.finishPage(pg);
            if (i == pageCount - 1) continue;
            PageBox nextPage = pages.get(i + 1);
            Rectangle2D.Float nextPageSize = new Rectangle2D.Float(0.0f, 0.0f, nextPage.getWidth((CssContext)c) / 1, nextPage.getHeight((CssContext)c) / 1);
            pg = this._pageProcessor.createPage(i + 1, (int)((RectangularShape)nextPageSize).getWidth(), (int)((RectangularShape)nextPageSize).getHeight());
            this._outputDevice.initializePage(pg.getGraphics());
        }
        this._outputDevice.finish(c, this._root);
    }

    private void paintPage(RenderingContext c, PageBox page) {
        page.paintBackground(c, 0, this._pagingMode);
        page.paintMarginAreas(c, 0, this._pagingMode);
        page.paintBorder(c, 0, this._pagingMode);
        Shape working = this._outputDevice.getClip();
        Rectangle content = page.getPrintClippingBounds((CssContext)c);
        this._outputDevice.clip(content);
        int top = -page.getPaintingTop() + page.getMarginBorderPadding((CssContext)c, 3);
        int left = page.getMarginBorderPadding((CssContext)c, 1);
        this._outputDevice.translate(left, top);
        this._root.getLayer().paint(c);
        this._outputDevice.translate(-left, -top);
        this._outputDevice.setClip(working);
    }

    @Override
    public void close() {
        this._sharedContext.removeFromThread();
        ThreadCtx.cleanup();
        if (this._svgImpl != null) {
            try {
                this._svgImpl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this._mathMLImpl != null) {
            try {
                this._mathMLImpl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

