/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.java2d.api;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.BidiSplitterFactory;
import com.openhtmltopdf.extend.FSCache;
import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.extend.FSTextBreaker;
import com.openhtmltopdf.extend.FSTextTransformer;
import com.openhtmltopdf.extend.FSUriResolver;
import com.openhtmltopdf.extend.HttpStreamFactory;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.java2d.Java2DRenderer;
import com.openhtmltopdf.java2d.api.FSPageProcessor;
import com.openhtmltopdf.outputdevice.helper.BaseDocument;
import com.openhtmltopdf.outputdevice.helper.PageDimensions;
import com.openhtmltopdf.outputdevice.helper.UnicodeImplementation;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.swing.EmptyReplacedElement;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public class Java2DRendererBuilder {
    private HttpStreamFactory _httpStreamFactory;
    private FSCache _cache;
    private FSUriResolver _resolver;
    private String _html;
    private String _baseUri;
    private Document _document;
    private SVGDrawer _svgImpl;
    private String _replacementText;
    private FSTextBreaker _lineBreaker;
    private FSTextBreaker _charBreaker;
    private FSTextTransformer _unicodeToUpperTransformer;
    private FSTextTransformer _unicodeToLowerTransformer;
    private FSTextTransformer _unicodeToTitleTransformer;
    private BidiSplitterFactory _splitter;
    private BidiReorderer _reorderer;
    private boolean _textDirection = false;
    private Float _pageWidth;
    private Float _pageHeight;
    private boolean _isPageSizeInches;
    private FSPageProcessor _pageProcessor;
    private String _uri;
    private File _file;
    private boolean _testMode = false;
    private Graphics2D _layoutGraphics;
    private int _initialPageNumber;
    private short _pagingMode = (short)2;
    private List<AddedFont> _fonts = new ArrayList<AddedFont>();

    public Java2DRendererBuilder useHttpStreamImplementation(HttpStreamFactory factory) {
        this._httpStreamFactory = factory;
        return this;
    }

    public Java2DRendererBuilder useUriResolver(FSUriResolver resolver) {
        this._resolver = resolver;
        return this;
    }

    public Java2DRendererBuilder useCache(FSCache cache) {
        this._cache = cache;
        return this;
    }

    public Java2DRendererBuilder withHtmlContent(String html, String baseUri) {
        this._html = html;
        this._baseUri = baseUri;
        return this;
    }

    public Java2DRendererBuilder withW3cDocument(Document doc, String baseUri) {
        this._document = doc;
        this._baseUri = baseUri;
        return this;
    }

    public Java2DRendererBuilder withUri(String uri) {
        this._uri = uri;
        return this;
    }

    public Java2DRendererBuilder useSVGDrawer(SVGDrawer svgImpl) {
        this._svgImpl = svgImpl;
        return this;
    }

    public Java2DRendererBuilder useLayoutGraphics(Graphics2D g2d) {
        this._layoutGraphics = g2d;
        return this;
    }

    public Java2DRendererBuilder defaultTextDirection(TextDirection textDirection) {
        this._textDirection = textDirection == TextDirection.RTL;
        return this;
    }

    public Java2DRendererBuilder testMode(boolean mode) {
        this._testMode = mode;
        return this;
    }

    public Java2DRendererBuilder useUnicodeBidiSplitter(BidiSplitterFactory splitter) {
        this._splitter = splitter;
        return this;
    }

    public Java2DRendererBuilder useUnicodeBidiReorderer(BidiReorderer reorderer) {
        this._reorderer = reorderer;
        return this;
    }

    public Java2DRendererBuilder withFile(File file) {
        this._file = file;
        return this;
    }

    public Java2DRendererBuilder useReplacementText(String replacement) {
        this._replacementText = replacement;
        return this;
    }

    public Java2DRendererBuilder useUnicodeLineBreaker(FSTextBreaker breaker) {
        this._lineBreaker = breaker;
        return this;
    }

    public Java2DRendererBuilder useUnicodeCharacterBreaker(FSTextBreaker breaker) {
        this._charBreaker = breaker;
        return this;
    }

    public Java2DRendererBuilder useUnicodeToUpperTransformer(FSTextTransformer tr) {
        this._unicodeToUpperTransformer = tr;
        return this;
    }

    public Java2DRendererBuilder useUnicodeToLowerTransformer(FSTextTransformer tr) {
        this._unicodeToLowerTransformer = tr;
        return this;
    }

    public Java2DRendererBuilder useUnicodeToTitleTransformer(FSTextTransformer tr) {
        this._unicodeToTitleTransformer = tr;
        return this;
    }

    public Java2DRendererBuilder useFont(FSSupplier<InputStream> supplier, String fontFamily, Integer fontWeight, FontStyle fontStyle) {
        this._fonts.add(new AddedFont(supplier, fontWeight, fontFamily, fontStyle));
        return this;
    }

    public Java2DRendererBuilder useFont(FSSupplier<InputStream> supplier, String fontFamily) {
        return this.useFont(supplier, fontFamily, 400, FontStyle.NORMAL);
    }

    public Java2DRendererBuilder useDefaultPageSize(float pageWidth, float pageHeight, PageSizeUnits units) {
        this._pageWidth = Float.valueOf(pageWidth);
        this._pageHeight = Float.valueOf(pageHeight);
        this._isPageSizeInches = units == PageSizeUnits.INCHES;
        return this;
    }

    public Java2DRendererBuilder useInitialPageNumber(int pageNumberInitial) {
        this._initialPageNumber = pageNumberInitial;
        return this;
    }

    public Java2DRendererBuilder toSinglePage(FSPageProcessor pageProcessor) {
        this._pagingMode = 1;
        this._pageProcessor = pageProcessor;
        return this;
    }

    public Java2DRendererBuilder toPageProcessor(FSPageProcessor pageProcessor) {
        this._pagingMode = (short)2;
        this._pageProcessor = pageProcessor;
        return this;
    }

    public void runPaged() throws Exception {
        Java2DRenderer renderer = this.buildJava2DRenderer();
        renderer.layout();
        if (this._pagingMode == 2) {
            renderer.writePages();
        } else {
            renderer.writeSinglePage();
        }
    }

    public void runFirstPage() throws Exception {
        Java2DRenderer renderer = this.buildJava2DRenderer();
        renderer.layout();
        if (this._pagingMode == 2) {
            renderer.writePage(0);
        } else {
            renderer.writeSinglePage();
        }
    }

    public Java2DRenderer buildJava2DRenderer() {
        UnicodeImplementation unicode = new UnicodeImplementation(this._reorderer, this._splitter, this._lineBreaker, this._unicodeToLowerTransformer, this._unicodeToUpperTransformer, this._unicodeToTitleTransformer, this._textDirection, this._charBreaker);
        PageDimensions pageSize = new PageDimensions(this._pageWidth, this._pageHeight, this._isPageSizeInches);
        BaseDocument doc = new BaseDocument(this._baseUri, this._html, this._document, this._file, this._uri);
        if (this._layoutGraphics == null) {
            BufferedImage bf = new BufferedImage(1, 1, 6);
            this._layoutGraphics = bf.createGraphics();
        }
        return new Java2DRenderer(doc, unicode, this._httpStreamFactory, this._resolver, this._cache, this._svgImpl, pageSize, this._replacementText, this._testMode, this._pageProcessor, this._layoutGraphics, this._initialPageNumber, this._pagingMode);
    }

    public static abstract class Graphics2DPaintingReplacedElement
    extends EmptyReplacedElement {
        public static double DOTS_PER_INCH = 72.0;

        protected Graphics2DPaintingReplacedElement(int width, int height) {
            super(width, height);
        }

        public abstract void paint(OutputDevice var1, RenderingContext var2, double var3, double var5, double var7, double var9);
    }

    private static class AddedFont {
        private final FSSupplier<InputStream> supplier;
        private final Integer weight;
        private final String family;
        private final FontStyle style;

        private AddedFont(FSSupplier<InputStream> supplier, Integer weight, String family, FontStyle style) {
            this.supplier = supplier;
            this.weight = weight;
            this.family = family;
            this.style = style;
        }
    }

    public static enum FontStyle {
        NORMAL,
        ITALIC,
        OBLIQUE;

    }

    public static enum PageSizeUnits {
        MM,
        INCHES;

    }

    public static enum TextDirection {
        RTL,
        LTR;

    }
}

