/*
 * Decompiled with CFR 0.152.
 */
package com.openai.core.http;

import com.openai.core.Utils;
import com.openai.core.http.HttpRequestBody;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0003\u0014\u0015\u0016B\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/openai/core/http/MultipartBody;", "Lcom/openai/core/http/HttpRequestBody;", "boundary", "", "parts", "", "Lcom/openai/core/http/MultipartBody$Part;", "(Ljava/lang/String;Ljava/util/List;)V", "boundaryBytes", "", "contentType", "close", "", "contentLength", "", "repeatable", "", "writeTo", "outputStream", "Ljava/io/OutputStream;", "Builder", "Companion", "Part", "openai-java-core"})
@SourceDebugExtension(value={"SMAP\nHttpRequestBodies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestBodies.kt\ncom/openai/core/http/MultipartBody\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n1855#2,2:245\n1855#2,2:247\n1726#2,3:249\n1855#2,2:252\n*S KotlinDebug\n*F\n+ 1 HttpRequestBodies.kt\ncom/openai/core/http/MultipartBody\n*L\n128#1:245,2\n158#1:247,2\n183#1:249,3\n186#1:252,2\n*E\n"})
final class MultipartBody
implements HttpRequestBody {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String boundary;
    @NotNull
    private final List<Part> parts;
    @NotNull
    private final byte[] boundaryBytes;
    @NotNull
    private final String contentType;
    @NotNull
    private static final byte[] CRLF;
    @NotNull
    private static final byte[] DASHDASH;
    @NotNull
    private static final byte[] CONTENT_DISPOSITION;
    @NotNull
    private static final byte[] CONTENT_TYPE;

    private MultipartBody(String boundary, List<Part> parts2) {
        this.boundary = boundary;
        this.parts = parts2;
        String string = this.boundary;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.boundaryBytes = byArray;
        this.contentType = "multipart/form-data; boundary=" + this.boundary;
    }

    @Override
    public void writeTo(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Iterable $this$forEach$iv = this.parts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Part part = (Part)element$iv;
            boolean bl = false;
            outputStream.write(DASHDASH);
            outputStream.write(this.boundaryBytes);
            outputStream.write(CRLF);
            outputStream.write(CONTENT_DISPOSITION);
            byte[] byArray = part.getContentDisposition().getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            outputStream.write(byArray);
            outputStream.write(CRLF);
            outputStream.write(CONTENT_TYPE);
            byte[] byArray2 = part.getContentType().getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            outputStream.write(byArray2);
            outputStream.write(CRLF);
            outputStream.write(CRLF);
            part.getBody().writeTo(outputStream);
            outputStream.write(CRLF);
        }
        outputStream.write(DASHDASH);
        outputStream.write(this.boundaryBytes);
        outputStream.write(DASHDASH);
        outputStream.write(CRLF);
    }

    @Override
    @NotNull
    public String contentType() {
        return this.contentType;
    }

    @Override
    public long contentLength() {
        long byteCount = 0L;
        Iterable $this$forEach$iv = this.parts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Part part = (Part)element$iv;
            boolean bl = false;
            long contentLength = part.getBody().contentLength();
            if (contentLength == -1L) {
                return -1L;
            }
            int n = DASHDASH.length + this.boundaryBytes.length + CRLF.length + CONTENT_DISPOSITION.length;
            byte[] byArray = part.getContentDisposition().getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            int n2 = n + byArray.length + CRLF.length + CONTENT_TYPE.length;
            byte[] byArray2 = part.getContentType().getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            byteCount += (long)(n2 + byArray2.length + CRLF.length + CRLF.length) + contentLength + (long)CRLF.length;
        }
        return byteCount += (long)(DASHDASH.length + this.boundaryBytes.length + DASHDASH.length + CRLF.length);
    }

    @Override
    public boolean repeatable() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.parts;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Part it = (Part)element$iv;
                    boolean bl2 = false;
                    if (it.getBody().repeatable()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void close() {
        Iterable $this$forEach$iv = this.parts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Part it = (Part)element$iv;
            boolean bl = false;
            it.getBody().close();
        }
    }

    public /* synthetic */ MultipartBody(String boundary, List parts2, DefaultConstructorMarker $constructor_marker) {
        this(boundary, parts2);
    }

    static {
        Object object = new byte[]{13, 10};
        CRLF = object;
        object = new byte[]{45, 45};
        DASHDASH = object;
        object = "Content-Disposition: ";
        byte[] byArray = object.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        CONTENT_DISPOSITION = byArray;
        object = "Content-Type: ";
        byte[] byArray2 = object.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        CONTENT_TYPE = byArray2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/openai/core/http/MultipartBody$Builder;", "", "()V", "boundary", "", "parts", "", "Lcom/openai/core/http/MultipartBody$Part;", "addPart", "part", "build", "Lcom/openai/core/http/MultipartBody;", "openai-java-core"})
    @SourceDebugExtension(value={"SMAP\nHttpRequestBodies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestBodies.kt\ncom/openai/core/http/MultipartBody$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,244:1\n1#2:245\n*E\n"})
    public static final class Builder {
        @NotNull
        private final String boundary;
        @NotNull
        private final List<Part> parts;

        public Builder() {
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
            this.boundary = string;
            this.parts = new ArrayList();
        }

        @NotNull
        public final Builder addPart(@NotNull Part part) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)part, (String)"part");
            Builder $this$addPart_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$addPart_u24lambda_u240.parts.add(part);
            return builder;
        }

        @NotNull
        public final MultipartBody build() {
            return new MultipartBody(this.boundary, Utils.toImmutable(this.parts), null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t*\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/openai/core/http/MultipartBody$Companion;", "", "()V", "CONTENT_DISPOSITION", "", "CONTENT_TYPE", "CRLF", "DASHDASH", "appendQuotedString", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "key", "", "openai-java-core"})
    public static final class Companion {
        private Companion() {
        }

        private final void appendQuotedString(StringBuilder $this$appendQuotedString, String key) {
            $this$appendQuotedString.append('\"');
            int n = key.length();
            for (int i = 0; i < n; ++i) {
                char ch = key.charAt(i);
                char c = ch;
                if (c == '\n') {
                    $this$appendQuotedString.append("%0A");
                    continue;
                }
                if (c == '\r') {
                    $this$appendQuotedString.append("%0D");
                    continue;
                }
                if (c == '\"') {
                    $this$appendQuotedString.append("%22");
                    continue;
                }
                $this$appendQuotedString.append(ch);
            }
            $this$appendQuotedString.append('\"');
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/openai/core/http/MultipartBody$Part;", "", "contentDisposition", "", "contentType", "body", "Lcom/openai/core/http/HttpRequestBody;", "(Ljava/lang/String;Ljava/lang/String;Lcom/openai/core/http/HttpRequestBody;)V", "getBody", "()Lcom/openai/core/http/HttpRequestBody;", "getContentDisposition", "()Ljava/lang/String;", "getContentType", "Companion", "openai-java-core"})
    public static final class Part {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String contentDisposition;
        @NotNull
        private final String contentType;
        @NotNull
        private final HttpRequestBody body;

        private Part(String contentDisposition, String contentType, HttpRequestBody body) {
            this.contentDisposition = contentDisposition;
            this.contentType = contentType;
            this.body = body;
        }

        @NotNull
        public final String getContentDisposition() {
            return this.contentDisposition;
        }

        @NotNull
        public final String getContentType() {
            return this.contentType;
        }

        @NotNull
        public final HttpRequestBody getBody() {
            return this.body;
        }

        public /* synthetic */ Part(String contentDisposition, String contentType, HttpRequestBody body, DefaultConstructorMarker $constructor_marker) {
            this(contentDisposition, contentType, body);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/openai/core/http/MultipartBody$Part$Companion;", "", "()V", "create", "Lcom/openai/core/http/MultipartBody$Part;", "name", "", "filename", "contentType", "body", "Lcom/openai/core/http/HttpRequestBody;", "openai-java-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Part create(@NotNull String name, @Nullable String filename, @NotNull String contentType, @NotNull HttpRequestBody body) {
                StringBuilder stringBuilder;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                StringBuilder $this$create_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$create_u24lambda_u240.append("form-data; name=");
                MultipartBody.Companion.appendQuotedString($this$create_u24lambda_u240, name);
                if (filename != null) {
                    $this$create_u24lambda_u240.append("; filename=");
                    MultipartBody.Companion.appendQuotedString($this$create_u24lambda_u240, filename);
                }
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                String disposition = string;
                return new Part(disposition, contentType, body, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

