/*
 * Decompiled with CFR 0.152.
 */
package com.openai.services.blocking;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.openai.core.ClientOptions;
import com.openai.core.PrepareRequest;
import com.openai.core.RequestOptions;
import com.openai.core.handlers.ErrorHandler;
import com.openai.core.http.HttpMethod;
import com.openai.core.http.HttpRequest;
import com.openai.core.http.HttpRequestBody;
import com.openai.core.http.HttpResponse;
import com.openai.errors.OpenAIError;
import com.openai.errors.OpenAIException;
import com.openai.models.FileContentParams;
import com.openai.models.FileDeleteParams;
import com.openai.models.FileDeleted;
import com.openai.models.FileListPage;
import com.openai.models.FileListParams;
import com.openai.models.FileObject;
import com.openai.models.FileRetrieveParams;
import com.openai.services.blocking.FileService;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/openai/services/blocking/FileServiceImpl;", "Lcom/openai/services/blocking/FileService;", "clientOptions", "Lcom/openai/core/ClientOptions;", "<init>", "(Lcom/openai/core/ClientOptions;)V", "errorHandler", "Lcom/openai/core/http/HttpResponse$Handler;", "Lcom/openai/errors/OpenAIError;", "retrieveHandler", "Lcom/openai/models/FileObject;", "retrieve", "params", "Lcom/openai/models/FileRetrieveParams;", "requestOptions", "Lcom/openai/core/RequestOptions;", "listHandler", "Lcom/openai/models/FileListPage$Response;", "list", "Lcom/openai/models/FileListPage;", "Lcom/openai/models/FileListParams;", "deleteHandler", "Lcom/openai/models/FileDeleted;", "delete", "Lcom/openai/models/FileDeleteParams;", "content", "Lcom/openai/core/http/HttpResponse;", "Lcom/openai/models/FileContentParams;", "openai-java-core"})
@SourceDebugExtension(value={"SMAP\nFileServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileServiceImpl.kt\ncom/openai/services/blocking/FileServiceImpl\n+ 2 JsonHandler.kt\ncom/openai/core/handlers/JsonHandler\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 HttpRequestBodies.kt\ncom/openai/core/HttpRequestBodies\n*L\n1#1,105:1\n13#2,9:106\n13#2,9:115\n13#2,9:124\n1#3:133\n14#4:134\n*S KotlinDebug\n*F\n+ 1 FileServiceImpl.kt\ncom/openai/services/blocking/FileServiceImpl\n*L\n30#1:106,9\n51#1:115,9\n73#1:124,9\n81#1:134\n*E\n"})
public final class FileServiceImpl
implements FileService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<OpenAIError> errorHandler;
    @NotNull
    private final HttpResponse.Handler<FileObject> retrieveHandler;
    @NotNull
    private final HttpResponse.Handler<FileListPage.Response> listHandler;
    @NotNull
    private final HttpResponse.Handler<FileDeleted> deleteHandler;

    public FileServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.retrieveHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<FileObject>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public FileObject handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<FileObject>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.listHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<FileListPage.Response>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public FileListPage.Response handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<FileListPage.Response>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.deleteHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<FileDeleted>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public FileDeleted handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<FileDeleted>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FileObject retrieve(@NotNull FileRetrieveParams params, @NotNull RequestOptions requestOptions) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"files", params.getPathParam(0)};
        HttpRequest request = PrepareRequest.prepare(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params, null);
        HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions);
        Object object = response;
        Throwable throwable = null;
        try {
            it = (HttpResponse)object;
            boolean bl = false;
            it = this.retrieveHandler.handle((HttpResponse)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object it2 = object = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((FileObject)it2).validate();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FileListPage list(@NotNull FileListParams params, @NotNull RequestOptions requestOptions) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"files"};
        HttpRequest request = PrepareRequest.prepare(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params, null);
        HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions);
        Object object = response;
        Throwable throwable = null;
        try {
            it = (HttpResponse)object;
            boolean bl = false;
            it = this.listHandler.handle((HttpResponse)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object it2 = object = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((FileListPage.Response)it2).validate();
        }
        it2 = object;
        boolean bl3 = false;
        return FileListPage.Companion.of(this, params, (FileListPage.Response)it2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FileDeleted delete(@NotNull FileDeleteParams params, @NotNull RequestOptions requestOptions) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Object object = new String[]{"files", params.getPathParam(0)};
        Object $this$delete_u24lambda_u247 = object = HttpRequest.Companion.builder().method(HttpMethod.DELETE).addPathSegments((String[])object);
        boolean $i$a$-apply-FileServiceImpl$delete$request$22 = false;
        params._body$openai_java_core().ifPresent(arg_0 -> FileServiceImpl.delete$lambda$7$lambda$6(arg_0 -> FileServiceImpl.delete$lambda$7$lambda$5((HttpRequest.Builder)$this$delete_u24lambda_u247, this, arg_0), arg_0));
        HttpRequest request = PrepareRequest.prepare(((HttpRequest.Builder)object).build(), this.clientOptions, params, null);
        HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions);
        Object object2 = response;
        Throwable $i$a$-apply-FileServiceImpl$delete$request$22 = null;
        try {
            it = (HttpResponse)object2;
            boolean bl = false;
            it = this.deleteHandler.handle((HttpResponse)it);
        }
        catch (Throwable throwable) {
            $i$a$-apply-FileServiceImpl$delete$request$22 = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)$i$a$-apply-FileServiceImpl$delete$request$22);
        }
        Object it2 = object2 = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((FileDeleted)it2).validate();
        }
        return object2;
    }

    @Override
    @NotNull
    public HttpResponse content(@NotNull FileContentParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"files", params.getPathParam(0), "content"};
        HttpRequest request = PrepareRequest.prepare(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params, null);
        return this.clientOptions.httpClient().execute(request, requestOptions);
    }

    private static final Unit delete$lambda$7$lambda$5(HttpRequest.Builder $this_apply, FileServiceImpl this$0, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JsonMapper jsonMapper$iv = this$0.clientOptions.jsonMapper();
        boolean $i$f$json = false;
        $this_apply.body(new HttpRequestBody(jsonMapper$iv, it){
            private byte[] cachedBytes;
            final /* synthetic */ JsonMapper $jsonMapper;
            final /* synthetic */ T $value;
            {
                this.$jsonMapper = $jsonMapper;
                this.$value = $value;
            }

            private final byte[] serialize() {
                if (this.cachedBytes != null) {
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    this.$jsonMapper.writeValue((OutputStream)buffer, this.$value);
                    this.cachedBytes = buffer.toByteArray();
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                catch (Exception e) {
                    throw new OpenAIException("Error writing request", e);
                }
            }

            public void writeTo(OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.serialize());
            }

            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.serialize().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        });
        return Unit.INSTANCE;
    }

    private static final void delete$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

