/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.repository.http;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public class GraphDBScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static final int CORE_SIZE = 10;
    private static final int KEEP_FREE_SIZE = 5;
    private static final int MAXIMUM_SIZE = 200;
    private final int originalCoreSize;
    private final int keepFreeSize;

    public GraphDBScheduledThreadPoolExecutor() {
        this(10, 5, 200);
    }

    public GraphDBScheduledThreadPoolExecutor(int originalCoreSize, int keepFreeSize, int maximumSize) {
        super(originalCoreSize, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("graphdb-httpclient-%d").build());
        this.originalCoreSize = originalCoreSize;
        this.keepFreeSize = keepFreeSize;
        this.setMaximumPoolSize(maximumSize);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        int activeCount = this.getActiveCount();
        if (activeCount + this.keepFreeSize > this.getCorePoolSize() && activeCount + this.keepFreeSize < this.getMaximumPoolSize()) {
            this.setCorePoolSize(this.getCorePoolSize() + this.keepFreeSize);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        int activeCount = this.getActiveCount();
        if (this.getCorePoolSize() - activeCount > this.originalCoreSize) {
            this.setCorePoolSize(this.originalCoreSize);
        }
    }
}

