/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.repository.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.ontotext.graphdb.repository.http.ClusterLeaderListener;
import com.ontotext.graphdb.repository.http.ClusterNodeState;
import com.ontotext.graphdb.repository.http.DelegatingHttpClient;
import com.ontotext.graphdb.repository.http.GraphDBHTTPRepository;
import com.ontotext.graphdb.repository.http.GraphDBRequestPreprocessor;
import com.ontotext.graphdb.repository.http.GraphDBResponseHeaders;
import com.ontotext.graphdb.repository.http.ResponseHeaderAware;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.http.client.RDF4JProtocolSession;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphDBProtocolSession
extends RDF4JProtocolSession
implements ResponseHeaderAware,
ClusterLeaderListener {
    private static final Logger LOG = LoggerFactory.getLogger(GraphDBProtocolSession.class);
    private static final TypeReference<List<ClusterNodeState>> listOfClusterNodesType = new TypeReference<List<ClusterNodeState>>(){};
    private final Multimap<String, String> requestHeaders = LinkedHashMultimap.create();
    private GraphDBRequestPreprocessor requestPreprocessor = r -> {};
    private final ThreadLocal<GraphDBResponseHeaders> responseHeaders = new ThreadLocal();
    private final ThreadLocal<HttpUriRequest> requestMethod = new ThreadLocal();
    private final Field transactionURLField;
    private final GraphDBHTTPRepository repository;
    private String username;
    private String password;
    private final Set<String> urlsWithSecurity = new HashSet<String>();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final RequestConfig clusterStatusRequestConfig;

    GraphDBProtocolSession(HttpClient client, ExecutorService executor, GraphDBHTTPRepository repository) {
        super(client, executor);
        this.repository = repository;
        repository.addClusterLeaderListener(this);
        this.setHttpClient(new DelegatingHttpClient(client){

            @Override
            public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
                GraphDBProtocolSession.this.addHeadersToMethod(request);
                GraphDBProtocolSession.this.requestMethod.set(request);
                GraphDBProtocolSession.this.requestPreprocessor.processRequest(request);
                HttpResponse response = super.execute(request, context);
                GraphDBProtocolSession.this.responseHeaders.set(new GraphDBResponseHeaders(response));
                return response;
            }
        });
        try {
            this.transactionURLField = RDF4JProtocolSession.class.getDeclaredField("transactionURL");
            this.transactionURLField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        int clusterStatusTimeout = repository.getClusterStatusTimeout();
        this.clusterStatusRequestConfig = RequestConfig.custom().setConnectTimeout(clusterStatusTimeout).setConnectionRequestTimeout(clusterStatusTimeout).setSocketTimeout(clusterStatusTimeout).build();
    }

    void setHeader(String name, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Null not allowed as header value.");
        }
        name = name.toLowerCase();
        this.requestHeaders.removeAll((Object)name);
        this.requestHeaders.put((Object)name, (Object)value);
    }

    void addHeader(String name, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Null not allowed as header value.");
        }
        this.requestHeaders.put((Object)name.toLowerCase(), (Object)value);
    }

    void removeHeader(String name) {
        this.requestHeaders.removeAll((Object)name.toLowerCase());
    }

    private void addHeadersToMethod(HttpUriRequest method) {
        this.requestHeaders.asMap().forEach((name, values) -> values.forEach(value -> method.addHeader(name, value)));
    }

    @Override
    public List<String> getHeaders(String name) {
        GraphDBResponseHeaders h = this.responseHeaders.get();
        return h != null ? h.getHeaders(name) : Collections.emptyList();
    }

    @Override
    public String getFirstHeader(String name) {
        GraphDBResponseHeaders h = this.responseHeaders.get();
        return h != null ? h.getFirstHeader(name) : null;
    }

    void setRequestPreprocessor(GraphDBRequestPreprocessor requestPreprocessor) {
        this.requestPreprocessor = requestPreprocessor;
    }

    HttpUriRequest getRequestMethod() {
        return this.requestMethod.get();
    }

    public String getServerProtocol() throws IOException, RepositoryException {
        return this.doWithRetry(false, () -> {
            HttpGet method = this.applyAdditionalHeaders(new HttpGet(Protocol.getProtocolLocation((String)this.getServerURL())));
            try {
                String string = EntityUtils.toString((HttpEntity)this.executeOK((HttpUriRequest)method).getEntity());
                return string;
            }
            catch (RepositoryException e) {
                throw e;
            }
            catch (RDF4JException e) {
                throw new RepositoryException((Throwable)e);
            }
            finally {
                method.reset();
            }
        });
    }

    public void setUsernameAndPassword(String username, String password) {
        if (this.repository.isCluster()) {
            this.username = username;
            this.password = password;
        } else {
            super.setUsernameAndPassword(username, password);
        }
    }

    @Override
    public void onNewLeader(String leaderUrl) {
        if (this.username != null && !this.urlsWithSecurity.contains(leaderUrl)) {
            this.setUsernameAndPasswordForUrl(this.username, this.password, leaderUrl);
            this.urlsWithSecurity.add(leaderUrl);
        }
    }

    public synchronized void beginTransaction(TransactionSetting ... transactionSettings) throws RDF4JException, IOException {
        this.doWithRetryVoid(true, () -> super.beginTransaction(transactionSettings));
    }

    public void sendTupleQuery(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, TupleQueryResultHandler handler, Binding ... bindings) throws IOException, TupleQueryResultHandlerException, RepositoryException, MalformedQueryException, QueryInterruptedException {
        this.doWithRetryVoid(true, () -> super.sendTupleQuery(ql, query, baseURI, dataset, includeInferred, maxQueryTime, handler, bindings));
    }

    public TupleQueryResult sendTupleQuery(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, WeakReference<?> callerRef, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, QueryInterruptedException {
        return this.doWithRetry(true, () -> super.sendTupleQuery(ql, query, baseURI, dataset, includeInferred, maxQueryTime, callerRef, bindings));
    }

    public void sendGraphQuery(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, RDFHandler handler, Binding ... bindings) throws IOException, RDFHandlerException, RepositoryException, MalformedQueryException, QueryInterruptedException {
        this.doWithRetryVoid(true, () -> super.sendGraphQuery(ql, query, baseURI, dataset, includeInferred, maxQueryTime, handler, bindings));
    }

    public GraphQueryResult sendGraphQuery(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, WeakReference<?> callerRef, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, QueryInterruptedException {
        return this.doWithRetry(true, () -> super.sendGraphQuery(ql, query, baseURI, dataset, includeInferred, maxQueryTime, callerRef, bindings));
    }

    public boolean sendBooleanQuery(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, QueryInterruptedException {
        return this.doWithRetry(true, () -> super.sendBooleanQuery(ql, query, baseURI, dataset, includeInferred, maxQueryTime, bindings));
    }

    public void getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws IOException, RDFHandlerException, RepositoryException, QueryInterruptedException {
        this.doWithRetryVoid(true, () -> super.getStatements(subj, pred, obj, includeInferred, handler, contexts));
    }

    public void sendUpdate(QueryLanguage ql, String update, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, QueryInterruptedException {
        this.doWithRetryVoid(true, () -> super.sendUpdate(ql, update, baseURI, dataset, includeInferred, maxQueryTime, bindings));
    }

    public void addData(InputStream contents, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws RDFParseException, RepositoryException, IOException {
        this.doStreamingUpdate(() -> super.addData(contents, baseURI, dataFormat, contexts));
    }

    protected void upload(HttpEntity reqEntity, String baseURI, boolean overwrite, boolean preserveNodeIds, Protocol.Action action, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.doStreamingUpdate(() -> super.upload(reqEntity, baseURI, overwrite, preserveNodeIds, action, contexts));
    }

    public long size(Resource ... contexts) throws IOException, RepositoryException {
        return this.doWithRetry(true, () -> super.size(contexts));
    }

    public void getContextIDs(TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, QueryInterruptedException {
        this.doWithRetryVoid(false, () -> super.getContextIDs(handler));
    }

    public String getNamespace(String prefix) throws IOException, RepositoryException {
        return this.doWithRetry(false, () -> super.getNamespace(prefix));
    }

    public void getNamespaces(TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, QueryInterruptedException {
        this.doWithRetryVoid(false, () -> super.getNamespaces(handler));
    }

    public void setNamespacePrefix(String prefix, String name) throws IOException, RepositoryException {
        this.doWithRetryVoid(false, () -> super.setNamespacePrefix(prefix, name));
    }

    public void clearNamespaces() throws IOException, RepositoryException {
        this.doWithRetryVoid(false, () -> super.clearNamespaces());
    }

    public String getQueryURL() {
        return this.repository.getCurrentRepositoryURL();
    }

    public String getServerURL() {
        return this.repository.getCurrentServerURL();
    }

    public void close() {
        if (this.repository != null) {
            this.repository.removeClusterListener(this);
        }
        super.close();
    }

    Map<String, String> getClusterStatus(String serverURL) throws IOException {
        HttpGet get = new HttpGet(serverURL + "/rest/cluster/group/status");
        get.setConfig(this.clusterStatusRequestConfig);
        try (HttpResponse response = this.getHttpClient().execute((HttpUriRequest)get, this.getHttpContext());){
            int responseStatus = response.getStatusLine().getStatusCode();
            if (responseStatus == 200) {
                LOG.debug("Got cluster status from {}", (Object)serverURL);
                Map<String, String> map = ((List)this.objectMapper.readValue(new BasicResponseHandler().handleResponse(response), listOfClusterNodesType)).stream().collect(Collectors.toUnmodifiableMap(cns -> cns.endpoint, cns -> cns.nodeState));
                return map;
            }
            if (responseStatus == 404) {
                LOG.debug("Cluster group not found on {}", (Object)serverURL);
                Map<String, String> map = Collections.emptyMap();
                return map;
            }
            throw new HttpResponseException(responseStatus, response.getStatusLine().getReasonPhrase());
        }
    }

    private void doStreamingUpdate(VoidCallback callback) throws IOException {
        this.wrapInTransaction(callback);
    }

    private void onBeforeStreamingUpdate() throws IOException {
        if (!this.isTransaction()) {
            this.repository.invalidateCurrentLeader();
            this.getServerProtocol();
        }
    }

    private void wrapInTransaction(VoidCallback callback) throws IOException {
        boolean hasLocalTransaction = false;
        if (!this.isTransaction()) {
            this.beginTransaction(new TransactionSetting[0]);
            hasLocalTransaction = true;
        }
        try {
            callback.call();
            if (hasLocalTransaction) {
                this.commitTransaction();
            }
        }
        catch (IOException | RuntimeException e) {
            if (hasLocalTransaction) {
                this.rollbackTransaction();
            }
            throw e;
        }
    }

    private <T> T doWithRetry(boolean transactional, Callback<T> callback) throws IOException {
        return this.doWithRetry(transactional, callback, this.repository.getLeaderOperationRetries());
    }

    private void doWithRetryVoid(boolean transactional, VoidCallback callback) throws IOException {
        this.doWithRetry(transactional, callback);
    }

    private <T> T doWithRetry(boolean transactional, Callback<T> callback, int numRetriesLeft) throws IOException {
        try {
            return callback.call();
        }
        catch (MalformedQueryException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            this.repository.invalidateCurrentLeader();
            if (!(numRetriesLeft <= 0 || this.isTransaction() && transactional)) {
                return this.doWithRetry(transactional, callback, numRetriesLeft - 1);
            }
            throw e;
        }
    }

    private boolean isTransaction() {
        try {
            return this.transactionURLField.get(this) != null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private <T extends HttpUriRequest> T applyAdditionalHeaders(T method) {
        for (Map.Entry additionalHeader : this.getAdditionalHttpHeaders().entrySet()) {
            method.addHeader((String)additionalHeader.getKey(), (String)additionalHeader.getValue());
        }
        return method;
    }

    static interface VoidCallback
    extends Callback<Void> {
        @Override
        default public Void call() throws IOException {
            this.callVoid();
            return null;
        }

        public void callVoid() throws IOException;
    }

    static interface Callback<T> {
        public T call() throws IOException;
    }
}

