/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.repository.http;

import com.ontotext.graphdb.repository.http.GraphDBHTTPRepository;
import com.ontotext.graphdb.repository.http.GraphDBSharedHttpClientSessionManager;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.http.impl.client.HttpClientBuilder;

public class GraphDBHTTPRepositoryBuilder {
    private final HttpClientBuilder httpClientBuilder = GraphDBSharedHttpClientSessionManager.createDefaultHttpClientBuilder();
    private final Set<String> serverUrls = new LinkedHashSet<String>();
    private String repositoryId;
    private boolean isCluster;
    private int leaderDiscoveryRetries = 2;
    private int clusterStatusTimeout = GraphDBHTTPRepository.CLUSTER_STATUS_TIMEOUT_DEFAULT;
    private int leaderDiscoveryRetryDelay = GraphDBHTTPRepository.LEADER_DISCOVERY_RETRY_DELAY_DEFAULT;
    private int leaderOperationRetries = 1;

    public GraphDBHTTPRepositoryBuilder withRepositoryUrl(String repositoryUrl) {
        String serverUrl = GraphDBHTTPRepository.extractServerUrl(repositoryUrl);
        String repositoryId = GraphDBHTTPRepository.extractRepositoryId(repositoryUrl);
        return this.withServerUrl(serverUrl).withRepositoryId(repositoryId);
    }

    public GraphDBHTTPRepositoryBuilder withServerUrl(String serverUrl) {
        this.serverUrls.add(serverUrl);
        return this;
    }

    public GraphDBHTTPRepositoryBuilder withRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
        return this;
    }

    public GraphDBHTTPRepositoryBuilder withCluster() {
        this.isCluster = true;
        return this;
    }

    public GraphDBHTTPRepositoryBuilder withLeaderDiscoveryRetries(int leaderDiscoveryRetries) {
        this.leaderDiscoveryRetries = leaderDiscoveryRetries;
        return this;
    }

    public GraphDBHTTPRepositoryBuilder withLeaderDiscoveryRetryDelay(int leaderDiscoveryRetryDelay) {
        this.leaderDiscoveryRetryDelay = leaderDiscoveryRetryDelay;
        return this;
    }

    public GraphDBHTTPRepositoryBuilder withClusterStatusTimeout(int clusterStatusTimeout) {
        this.clusterStatusTimeout = clusterStatusTimeout;
        return this;
    }

    public GraphDBHTTPRepositoryBuilder withLeaderOperationRetries(int leaderOperationRetries) {
        this.leaderOperationRetries = leaderOperationRetries;
        return this;
    }

    public GraphDBHTTPRepositoryBuilder withHttpClientSetup(Consumer<HttpClientBuilder> httpClientSetup) {
        httpClientSetup.accept(this.httpClientBuilder);
        return this;
    }

    public GraphDBHTTPRepository build() {
        if (this.serverUrls.isEmpty()) {
            throw new IllegalStateException("At least one server URL must be provided");
        }
        if (this.repositoryId == null) {
            throw new IllegalStateException("Repository ID must be provided and cannot be null");
        }
        return new GraphDBHTTPRepository(new ArrayList<String>(this.serverUrls), this.repositoryId, this.httpClientBuilder, this.isCluster, this.leaderDiscoveryRetries, this.leaderDiscoveryRetryDelay, this.clusterStatusTimeout, this.leaderOperationRetries);
    }
}

