/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.repository.http;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.repository.http.ClusterLeaderListener;
import com.ontotext.graphdb.repository.http.GraphDBHTTPRepositoryConnection;
import com.ontotext.graphdb.repository.http.GraphDBProtocolSession;
import com.ontotext.graphdb.repository.http.GraphDBSharedHttpClientSessionManager;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.http.HTTPRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphDBHTTPRepository
extends HTTPRepository {
    private static final Logger LOG = LoggerFactory.getLogger(GraphDBHTTPRepository.class);
    static final int LEADER_DISCOVERY_RETRIES_DEFAULT = 2;
    static final int CLUSTER_STATUS_TIMEOUT_DEFAULT = (int)TimeUnit.SECONDS.toMillis(5L);
    static final int LEADER_DISCOVERY_RETRY_DELAY_DEFAULT = (int)TimeUnit.SECONDS.toMillis(5L);
    static final int LEADER_OPERATION_RETRIES_DEFAULT = 1;
    private final boolean isCluster;
    private boolean hasLeader;
    private String currentServerURL;
    private String currentRepositoryURL;
    private final List<ClusterLeaderListener> clusterLeaderListeners = new LinkedList<ClusterLeaderListener>();
    private final int leaderDiscoveryRetries;
    private final int leaderDiscoveryRetryDelay;
    private final int clusterStatusTimeout;
    private final int leaderOperationRetries;
    private final String repositoryId;
    private final Set<String> staticEndpoints;
    private Set<String> dynamicEndpoints;

    public GraphDBHTTPRepository(String repositoryURL) {
        this(Collections.singletonList(GraphDBHTTPRepository.extractServerUrl(repositoryURL)), GraphDBHTTPRepository.extractRepositoryId(repositoryURL), false);
    }

    public GraphDBHTTPRepository(String serverURL, String repositoryID) {
        this(Collections.singletonList(serverURL), repositoryID, false);
    }

    public GraphDBHTTPRepository(List<String> serverURLs, String repositoryId) {
        this(serverURLs, repositoryId, true);
    }

    private GraphDBHTTPRepository(List<String> serverURLs, String repositoryId, boolean isCluster) {
        this(serverURLs, repositoryId, null, isCluster, 2, LEADER_DISCOVERY_RETRY_DELAY_DEFAULT, CLUSTER_STATUS_TIMEOUT_DEFAULT, 1);
    }

    GraphDBHTTPRepository(List<String> serverURLs, String repositoryId, HttpClientBuilder httpClientBuilder, boolean isCluster, int leaderDiscoveryRetries, int leaderDiscoveryRetryDelay, int clusterStatusTimeout, int leaderOperationRetries) {
        super("dummy", repositoryId);
        this.staticEndpoints = new LinkedHashSet<String>(serverURLs);
        this.repositoryId = repositoryId;
        this.isCluster = isCluster;
        if (!isCluster) {
            if (serverURLs.size() != 1) {
                throw new IllegalArgumentException("In non-cluster mode exactly one server URL must be provided");
            }
            this.currentServerURL = serverURLs.get(0);
            this.currentRepositoryURL = Protocol.getRepositoryLocation((String)this.currentServerURL, (String)this.repositoryId);
        }
        this.leaderDiscoveryRetries = leaderDiscoveryRetries;
        if (leaderDiscoveryRetries < 0) {
            throw new IllegalArgumentException("Leader discovery retries must be 0 or greater");
        }
        this.clusterStatusTimeout = clusterStatusTimeout;
        this.leaderDiscoveryRetryDelay = leaderDiscoveryRetryDelay;
        if (leaderDiscoveryRetryDelay < 0) {
            throw new IllegalArgumentException("Leader discovery retry delay must be 0 or greater");
        }
        this.leaderOperationRetries = leaderOperationRetries;
        if (leaderOperationRetries < 1) {
            throw new IllegalArgumentException("Leader operation retries must be 1 or greater");
        }
        this.setHttpClientSessionManager((HttpClientSessionManager)new GraphDBSharedHttpClientSessionManager(httpClientBuilder, this));
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        return new GraphDBHTTPRepositoryConnection((HTTPRepository)this, (GraphDBProtocolSession)this.createHTTPClient());
    }

    protected void shutDownInternal() throws RepositoryException {
        this.getHttpClientSessionManager().shutDown();
        super.shutDownInternal();
    }

    public void setHttpClient(HttpClient httpClient) {
        throw new IllegalStateException("GraphDBHTTPRepository does not support setting HttpClient directly. Use GraphDBHTTPRepositoryBuilder.withHttpClientSetup() instead.");
    }

    public void addClusterLeaderListener(ClusterLeaderListener listener) {
        Objects.requireNonNull(listener, "Listener must not be null");
        this.clusterLeaderListeners.add(listener);
    }

    public void removeClusterListener(ClusterLeaderListener listener) {
        this.clusterLeaderListeners.remove(listener);
    }

    int getClusterStatusTimeout() {
        return this.clusterStatusTimeout;
    }

    int getLeaderOperationRetries() {
        return this.leaderOperationRetries;
    }

    void determineLeader() {
        if (this.hasLeader || !this.isCluster) {
            return;
        }
        if (this.dynamicEndpoints == null) {
            this.dynamicEndpoints = new LinkedHashSet<String>(this.staticEndpoints);
        }
        String newLeader = null;
        block9: for (int i = 0; i <= this.leaderDiscoveryRetries; ++i) {
            for (String serverUrl : this.dynamicEndpoints) {
                try {
                    GraphDBProtocolSession client = (GraphDBProtocolSession)this.createHTTPClient();
                    try {
                        client.onNewLeader(serverUrl);
                        Map<String, String> nodes = client.getClusterStatus(serverUrl);
                        newLeader = this.getClusterLeader(nodes);
                        if (newLeader == null) continue;
                        this.dynamicEndpoints = new LinkedHashSet<String>(this.staticEndpoints);
                        this.dynamicEndpoints.addAll(nodes.keySet());
                        break block9;
                    }
                    finally {
                        if (client == null) continue;
                        client.close();
                    }
                }
                catch (IOException | RuntimeException e) {
                    LOG.warn("Could not get cluster status from " + serverUrl, (Throwable)e);
                }
            }
            if (this.leaderDiscoveryRetryDelay <= 0) continue;
            try {
                Thread.sleep(this.leaderDiscoveryRetryDelay);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (newLeader != null) {
            this.hasLeader = true;
            if (!newLeader.equals(this.currentServerURL)) {
                this.notifyNewLeader(newLeader);
            }
        } else {
            throw new RepositoryException("Unable to determine the current leader");
        }
        this.currentServerURL = newLeader;
        this.currentRepositoryURL = Protocol.getRepositoryLocation((String)this.currentServerURL, (String)this.repositoryId);
    }

    String getCurrentServerURL() {
        this.determineLeader();
        return this.currentServerURL;
    }

    String getCurrentRepositoryURL() {
        this.determineLeader();
        return this.currentRepositoryURL;
    }

    void invalidateCurrentLeader() {
        if (this.isCluster) {
            this.hasLeader = false;
        }
    }

    boolean isCluster() {
        return this.isCluster;
    }

    @VisibleForTesting
    String getClusterLeader(Map<String, String> nodes) {
        return nodes.entrySet().stream().filter(e -> "LEADER".equals(e.getValue())).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    private void notifyNewLeader(String leaderUrl) {
        for (ClusterLeaderListener listener : this.clusterLeaderListeners) {
            try {
                listener.onNewLeader(leaderUrl);
            }
            catch (RuntimeException e) {
                LOG.warn("Error on notifying cluster leader listener on new leader", (Throwable)e);
            }
        }
    }

    static String extractServerUrl(String repositoryURL) {
        return repositoryURL.split("/repositories/")[0];
    }

    static String extractRepositoryId(String repositoryURL) {
        return repositoryURL.split("/repositories/")[1];
    }
}

