/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk.model;

import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onradar.sdk.model.RadarGeofence;
import com.onradar.sdk.model.RadarPlace;
import com.onradar.sdk.model.RadarUserInsights;
import java.text.ParseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RadarUser {
    private String mId;
    private String mUserId;
    private String mDeviceId;
    private String mDescription;
    private JSONObject mMetadata;
    private Location mLocation;
    private RadarGeofence[] mGeofences;
    private RadarPlace mPlace;
    private RadarUserInsights mInsights;

    public RadarUser(String _id, String userId, String deviceId, String description, JSONObject metadata, Location location, RadarGeofence[] geofences, RadarPlace place, RadarUserInsights insights) {
        this.mId = _id;
        this.mUserId = userId;
        this.mDeviceId = deviceId;
        this.mDescription = description;
        this.mMetadata = metadata;
        this.mLocation = location;
        this.mGeofences = geofences;
        this.mPlace = place;
        this.mInsights = insights;
    }

    public RadarUser(JSONObject obj) throws JSONException, ParseException {
        JSONObject locationObj;
        if (obj == null) {
            return;
        }
        if (obj.has("_id") && !obj.isNull("_id")) {
            this.mId = obj.getString("_id");
        }
        if (obj.has("userId") && !obj.isNull("userId")) {
            this.mUserId = obj.getString("userId");
        }
        if (obj.has("deviceId") && !obj.isNull("deviceId")) {
            this.mDeviceId = obj.getString("deviceId");
        }
        if (obj.has("description") && !obj.isNull("description")) {
            this.mDescription = obj.getString("description");
        }
        if (obj.has("metadata") && !obj.isNull("metadata")) {
            this.mMetadata = obj.getJSONObject("metadata");
        }
        if (obj.has("location") && !obj.isNull("location") && (locationObj = obj.getJSONObject("location")).has("coordinates")) {
            JSONArray coordinatesArr = locationObj.getJSONArray("coordinates");
            double longitude = coordinatesArr.getDouble(0);
            double latitude = coordinatesArr.getDouble(1);
            Location location = new Location("");
            location.setLongitude(longitude);
            location.setLatitude(latitude);
            if (obj.has("locationAccuracy") && !obj.isNull("locationAccuracy")) {
                float accuracy = (float)obj.getDouble("locationAccuracy");
                location.setAccuracy(accuracy);
            }
            this.mLocation = location;
        }
        if (obj.has("geofences") && !obj.isNull("geofences")) {
            JSONArray geofencesArr = obj.getJSONArray("geofences");
            int numGeofences = geofencesArr.length();
            this.mGeofences = new RadarGeofence[numGeofences];
            for (int i = 0; i < numGeofences; ++i) {
                RadarGeofence geofence;
                JSONObject geofenceObj = geofencesArr.getJSONObject(i);
                this.mGeofences[i] = geofence = new RadarGeofence(geofenceObj);
            }
        }
        if (obj.has("place") && !obj.isNull("place")) {
            this.mPlace = new RadarPlace(obj.getJSONObject("place"));
        }
        if (obj.has("insights") && !obj.isNull("insights")) {
            this.mInsights = new RadarUserInsights(obj.getJSONObject("insights"));
        }
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @Nullable
    public String getUserId() {
        return this.mUserId;
    }

    @Nullable
    public String getDeviceId() {
        return this.mUserId;
    }

    @Nullable
    public String getDescription() {
        return this.mDescription;
    }

    @Nullable
    public JSONObject getMetadata() {
        return this.mMetadata;
    }

    @NonNull
    public Location getLocation() {
        return this.mLocation;
    }

    @Nullable
    public RadarGeofence[] getGeofences() {
        return this.mGeofences;
    }

    @Nullable
    public RadarPlace getPlace() {
        return this.mPlace;
    }

    @Nullable
    public RadarUserInsights getInsights() {
        return this.mInsights;
    }
}

