/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.location.Location;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.onradar.sdk.Radar;
import com.onradar.sdk._RadarLogger;
import java.util.Date;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

class _RadarSettings {
    _RadarSettings() {
    }

    static void setPublishableKey(Context context, String publishableKey) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-publishableKey", publishableKey);
        editor.commit();
    }

    static String readPublishableKey(Context context) {
        if (context == null) {
            return null;
        }
        try {
            String publishableKey = context.getResources().getString(context.getResources().getIdentifier("radar_pk", "string", context.getPackageName()));
            _RadarSettings.setPublishableKey(context, publishableKey);
            return publishableKey;
        }
        catch (Resources.NotFoundException e) {
            return null;
        }
    }

    static String getPublishableKey(Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        return preferences.getString("radar-publishableKey", null);
    }

    static void setUserId(Context context, String userId) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-userId", userId);
        editor.commit();
    }

    static String getUserId(Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        return preferences.getString("radar-userId", null);
    }

    static void setDescription(Context context, String description) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-description", description);
        editor.commit();
    }

    static String getDescription(Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        return preferences.getString("radar-description", null);
    }

    static void setMetadata(Context context, JSONObject metadata) {
        String metadataStr;
        if (context == null) {
            return;
        }
        if (metadata != null) {
            if (metadata.length() > 16) {
                return;
            }
            try {
                Iterator keys = metadata.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    Object value = metadata.get(key);
                    if (value instanceof String || value instanceof Number || value instanceof Boolean) continue;
                    return;
                }
                metadataStr = metadata.toString();
            }
            catch (JSONException e) {
                metadataStr = null;
            }
        } else {
            metadataStr = null;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-metadata", metadataStr);
        editor.commit();
    }

    static String getMetadataStr(Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        return preferences.getString("radar-metadata", null);
    }

    static void setPlacesProvider(Context context, Radar.RadarPlacesProvider provider) {
        String providerStr = "none";
        if (provider == Radar.RadarPlacesProvider.FACEBOOK) {
            providerStr = "facebook";
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-placesProvider", providerStr);
        editor.commit();
    }

    static Radar.RadarPlacesProvider getPlacesProvider(Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        String providerStr = preferences.getString("radar-placesProvider", "none");
        Radar.RadarPlacesProvider provider = Radar.RadarPlacesProvider.NONE;
        if (providerStr.equals("facebook")) {
            provider = Radar.RadarPlacesProvider.FACEBOOK;
        }
        return provider;
    }

    static void setTrackingPriority(Context context, Radar.RadarPriority priority) {
        String priorityStr = "responsiveness";
        if (priority == Radar.RadarPriority.EFFICIENCY) {
            priorityStr = "efficiency";
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-trackingPriority", priorityStr);
        editor.commit();
    }

    static Radar.RadarPriority getTrackingPriority(Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        String priorityStr = preferences.getString("radar-trackingPriority", "responsiveness");
        Radar.RadarPriority priority = Radar.RadarPriority.RESPONSIVENESS;
        if (priorityStr.equals("efficiency")) {
            priority = Radar.RadarPriority.EFFICIENCY;
        }
        return priority;
    }

    static void setTracking(Context context, boolean tracking) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean("radar-tracking", tracking);
        editor.commit();
    }

    static boolean getTracking(Context context) {
        if (context == null) {
            return false;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        return preferences.getBoolean("radar-tracking", false);
    }

    static void updateSentAt(Context context) {
        if (context == null) {
            return;
        }
        Date now = new Date();
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putLong("radar-sentAt", now.getTime());
        editor.commit();
    }

    static Date getSentAt(Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        long timestamp = preferences.getLong("radar-sentAt", 0L);
        return new Date(timestamp);
    }

    static void setAdId(final Context context) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        final SharedPreferences.Editor editor = preferences.edit();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
                    if (info.isLimitAdTrackingEnabled()) {
                        editor.putString("radar-ad-id", "OptedOut");
                    } else {
                        editor.putString("radar-ad-id", info.getId());
                    }
                    editor.commit();
                }
                catch (Throwable t) {
                    _RadarLogger.log(context, "error getting advertising ID: " + t.getMessage());
                }
            }
        }).start();
    }

    static String getAdId(Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        return preferences.getString("radar-ad-id", null);
    }

    static String getHost(Context context) {
        String host = "https://api.radar.io";
        if (context == null) {
            return host;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        host = preferences.getString("radar-host", host);
        return host;
    }

    static boolean isDebug(Context context) {
        if (context == null) {
            return false;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        return preferences.getBoolean("radar-debug", false);
    }

    private static Location getLastMovingLocation(Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        double latitude = preferences.getFloat("radar-lastMovingLocationLatitude", 0.0f);
        double longitude = preferences.getFloat("radar-lastMovingLocationLongitude", 0.0f);
        float accuracy = preferences.getFloat("radar-lastMovingLocationAccuracy", 0.0f);
        long timestamp = preferences.getLong("radar-lastMovingLocationTimestamp", 0L);
        if (longitude == 0.0 || latitude == 0.0 || accuracy == 0.0f || timestamp == 0L) {
            return null;
        }
        Location location = new Location("RadarSDK");
        location.setLatitude(latitude);
        location.setLongitude(longitude);
        location.setAccuracy(accuracy);
        location.setTime(timestamp);
        return location;
    }

    static void updateLastMovingLocation(Context context, Location location) {
        if (context == null) {
            return;
        }
        Location lastMovingLocation = _RadarSettings.getLastMovingLocation(context);
        if (lastMovingLocation == null || location != null && location.distanceTo(lastMovingLocation) > 70.0f) {
            SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
            SharedPreferences.Editor editor = preferences.edit();
            editor.putFloat("radar-lastMovingLocationLatitude", (float)location.getLatitude());
            editor.putFloat("radar-lastMovingLocationLongitude", (float)location.getLongitude());
            editor.putFloat("radar-lastMovingLocationAccuracy", location.getAccuracy());
            editor.putLong("radar-lastMovingLocationTimestamp", location.getTime());
            editor.commit();
        }
    }

    static boolean isStopped(Context context, Location location) {
        if (context == null) {
            return false;
        }
        Location lastMovingLocation = _RadarSettings.getLastMovingLocation(context);
        boolean stopped = false;
        float distance = -1.0f;
        float interval = -1.0f;
        if (location != null && lastMovingLocation != null) {
            distance = location.distanceTo(lastMovingLocation);
            interval = location.getTime() - lastMovingLocation.getTime();
            stopped = distance <= 70.0f && interval >= 140000.0f;
        }
        String stoppedLog = (stopped ? "stopped" : "moving") + ", " + distance + " meters, " + interval / 1000.0f + " seconds";
        _RadarLogger.log(context, stoppedLog);
        _RadarLogger.notify(context, stoppedLog);
        if (stopped) {
            Date stoppedAt = _RadarSettings.getStoppedAt(context);
            if (stoppedAt == null) {
                _RadarSettings.updateStoppedAt(context, location.getTime());
            }
        } else {
            _RadarSettings.clearStoppedAt(context);
        }
        return stopped;
    }

    static void clearStoppedAt(Context context) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putLong("radar-stoppedAt", 0L);
        editor.commit();
    }

    private static void updateStoppedAt(Context context, long time) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putLong("radar-stoppedAt", time);
        editor.commit();
    }

    static Date getStoppedAt(Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        long timestamp = preferences.getLong("radar-stoppedAt", 0L);
        if (timestamp == 0L) {
            return null;
        }
        return new Date(timestamp);
    }
}

