/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk.model;

import com.onradar.sdk.model.RadarGeofence;
import com.onradar.sdk.model.RadarPlace;
import com.onradar.sdk.model.RadarUserInsights;
import java.text.ParseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RadarUser {
    private String mId;
    private String mUserId;
    private String mDescription;
    private RadarGeofence[] mGeofences;
    private RadarPlace mPlace;
    private RadarUserInsights mInsights;

    public RadarUser(String _id, String userId, String description, RadarGeofence[] geofences, RadarPlace place, RadarUserInsights insights) {
        this.mId = _id;
        this.mUserId = userId;
        this.mDescription = description;
        this.mGeofences = geofences;
        this.mPlace = place;
        this.mInsights = insights;
    }

    public RadarUser(JSONObject obj) throws JSONException, ParseException {
        if (obj == null) {
            return;
        }
        if (obj.has("_id") && !obj.isNull("_id")) {
            this.mId = obj.getString("_id");
        }
        if (obj.has("userId") && !obj.isNull("userId")) {
            this.mUserId = obj.getString("userId");
        }
        if (obj.has("description") && !obj.isNull("description")) {
            this.mDescription = obj.getString("description");
        }
        if (obj.has("geofences") && !obj.isNull("geofences")) {
            JSONArray geofencesArr = obj.getJSONArray("geofences");
            int numGeofences = geofencesArr.length();
            this.mGeofences = new RadarGeofence[numGeofences];
            for (int i = 0; i < numGeofences; ++i) {
                RadarGeofence geofence;
                JSONObject geofenceObj = geofencesArr.getJSONObject(i);
                this.mGeofences[i] = geofence = new RadarGeofence(geofenceObj);
            }
        }
        if (obj.has("place") && !obj.isNull("place")) {
            this.mPlace = new RadarPlace(obj.getJSONObject("place"));
        }
        if (obj.has("insights") && !obj.isNull("insights")) {
            this.mInsights = new RadarUserInsights(obj.getJSONObject("insights"));
        }
    }

    public String getId() {
        return this.mId;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public RadarGeofence[] getGeofences() {
        return this.mGeofences;
    }

    public RadarPlace getPlace() {
        return this.mPlace;
    }

    public RadarUserInsights getInsights() {
        return this.mInsights;
    }
}

