/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.Context;
import android.location.Location;
import android.os.Handler;
import android.os.PersistableBundle;
import android.support.annotation.RequiresApi;
import com.onradar.sdk._Radar;
import com.onradar.sdk._RadarLogger;

@RequiresApi(value=22)
public final class _RadarJobService
extends JobService {
    static final int JOB_PERIOD = 900000;
    static final int JOB_ID_GEOFENCES = 1;
    static final int JOB_ID_LOCATION = 2;
    private Handler mHandler;

    public boolean onStartJob(final JobParameters params) {
        Context context = this.getApplicationContext();
        _Radar.getSharedInstance().initialize(context, null);
        final _RadarJobService service = this;
        if (this.mHandler == null) {
            this.mHandler = new Handler();
        }
        if (params.getJobId() == 2) {
            _RadarLogger.log(context, "location job started");
            _RadarLogger.notify(context, "location job started");
            PersistableBundle extras = params.getExtras();
            double latitude = extras.getDouble("latitude");
            double longitude = extras.getDouble("longitude");
            float accuracy = (float)extras.getDouble("accuracy");
            boolean foreground = extras.getBoolean("foreground");
            boolean stopped = extras.getBoolean("stopped");
            Location location = new Location("radar");
            location.setLatitude(latitude);
            location.setLongitude(longitude);
            location.setAccuracy(accuracy);
            _Radar.getSharedInstance().sendLocation(location, foreground, stopped, null);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Context context = service.getApplicationContext();
                    _RadarLogger.log(context, "location job finished");
                    _RadarLogger.notify(context, "location job finished");
                    service.jobFinished(params, false);
                }
            }, 10000L);
        } else {
            _RadarLogger.log(context, "geofence job started");
            _RadarLogger.notify(context, "geofence job started");
            _Radar.getSharedInstance().updateGeofences(null);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Context context = service.getApplicationContext();
                    _RadarLogger.log(context, "geofence job finished");
                    _RadarLogger.notify(context, "geofence job finished");
                    service.jobFinished(params, false);
                }
            }, 10000L);
        }
        return true;
    }

    public boolean onStopJob(JobParameters params) {
        Context context = this.getApplicationContext();
        _RadarLogger.log(context, "job killed");
        _RadarLogger.notify(context, "job killed");
        return false;
    }
}

