/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.content.Context;
import android.location.Location;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.Volley;
import com.onradar.sdk.Radar;
import com.onradar.sdk._CustomJsonObjectRequest;
import com.onradar.sdk._RadarCallback;
import com.onradar.sdk._RadarLogger;
import com.onradar.sdk._RadarSettings;
import com.onradar.sdk._RadarUtils;
import com.onradar.sdk.model.RadarEvent;
import com.onradar.sdk.model.RadarUser;
import java.text.ParseException;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class _RadarClient {
    private static _RadarClient sInstance;
    private RequestQueue mRequestQueue;
    private boolean mSending;

    _RadarClient() {
    }

    static synchronized _RadarClient getSharedInstance() {
        if (sInstance == null) {
            sInstance = new _RadarClient();
        }
        return sInstance;
    }

    void updateLocation(final Context context, Location location, final boolean foreground, final boolean stopped, final _RadarCallback callback) {
        _RadarClient client = this;
        if (this.mSending) {
            return;
        }
        this.mSending = true;
        final String publishableKey = _RadarSettings.getPublishableKey(context);
        if (publishableKey == null || publishableKey.length() == 0) {
            callback.onCallback(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null);
            this.mSending = false;
            return;
        }
        final String userId = _RadarSettings.getUserId(context);
        if (userId == null || userId.length() == 0) {
            callback.onCallback(Radar.RadarStatus.ERROR_USER_ID, null, null, null);
            this.mSending = false;
            return;
        }
        final String oldUserId = _RadarSettings.getOldUserId(context);
        final String description = _RadarSettings.getDescription(context);
        final String metadata = _RadarSettings.getMetadataStr(context);
        final Double longitude = location.getLongitude();
        final Double latitude = location.getLatitude();
        final Float accuracy = Float.valueOf(location.getAccuracy());
        final Double altitude = location.getAltitude();
        final Float speed = Float.valueOf(location.getSpeed());
        final Float course = Float.valueOf(location.getBearing());
        final String adId = _RadarSettings.getAdId(context);
        final String deviceMake = _RadarUtils.getDeviceMake();
        final String deviceModel = _RadarUtils.getDeviceModel();
        final String deviceOS = _RadarUtils.getDeviceOS();
        final String country = _RadarUtils.getCountry();
        final Integer timeZoneOffset = _RadarUtils.getTimeZoneOffset();
        final String sdkVersion = _RadarUtils.getSDKVersion();
        String wifi = _RadarUtils.getWifi(context);
        _RadarLogger.log(context, "sending wifi: " + wifi);
        final String uaChannelId = _RadarUtils.getUrbanAirshipChannelId();
        final String uaNamedUserId = _RadarUtils.getUrbanAirshipNamedUserId();
        client.getFacebookPlacesForLocation(context, location, foreground || stopped, new _RadarFacebookPlacesCallback(){

            @Override
            void onCallback(boolean error, String facebookPlaces) {
                if (error) {
                    callback.onCallback(Radar.RadarStatus.ERROR_PLACES, null, null, null);
                    _RadarClient.this.mSending = false;
                    return;
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("deviceType", "Android");
                params.put("longitude", longitude);
                params.put("latitude", latitude);
                params.put("accuracy", accuracy);
                params.put("foreground", foreground ? "true" : "false");
                params.put("stopped", stopped ? "true" : "false");
                params.put("altitude", altitude);
                params.put("speed", speed);
                params.put("course", course);
                params.put("deviceMake", deviceMake);
                params.put("deviceModel", deviceModel);
                params.put("deviceOS", deviceOS);
                params.put("country", country);
                params.put("timeZoneOffset", timeZoneOffset);
                params.put("sdkVersion", sdkVersion);
                if (oldUserId != null) {
                    params.put("oldUserId", oldUserId);
                }
                if (description != null) {
                    params.put("description", description);
                }
                if (metadata != null) {
                    params.put("metadata", metadata);
                }
                if (adId != null) {
                    params.put("adId", adId);
                }
                if (facebookPlaces != null) {
                    _RadarLogger.log(context, "sending facebookPlaces: " + facebookPlaces);
                    params.put("facebookPlaces", facebookPlaces);
                }
                if (uaChannelId != null) {
                    _RadarLogger.log(context, "sending uaChannelId: " + uaChannelId);
                    params.put("uaChannelId", uaChannelId);
                    params.put("uaSessionId", "radar");
                }
                if (uaNamedUserId != null) {
                    _RadarLogger.log(context, "sending uaNamedUserId: " + uaNamedUserId);
                    params.put("uaNamedUserId", uaNamedUserId);
                }
                VolleyLog.DEBUG = _RadarSettings.isDebug(context);
                if (_RadarClient.this.mRequestQueue == null) {
                    _RadarClient.this.mRequestQueue = Volley.newRequestQueue((Context)context);
                }
                String host = _RadarSettings.getHost(context);
                String locationURL = host + "/v1/users/" + userId;
                _CustomJsonObjectRequest locationRequest = new _CustomJsonObjectRequest(2, locationURL, new JSONObject(params), new Response.Listener<JSONObject>(){

                    public void onResponse(JSONObject response) {
                        if (response != null) {
                            try {
                                JSONArray eventsArr = response.getJSONArray("events");
                                JSONObject userObj = response.getJSONObject("user");
                                RadarEvent[] events = RadarEvent.eventsFromJSONArray(eventsArr);
                                RadarUser user = new RadarUser(userObj);
                                callback.onCallback(Radar.RadarStatus.SUCCESS, response, events, user);
                                _RadarClient.this.mSending = false;
                            }
                            catch (ParseException | JSONException e) {
                                _RadarLogger.log(context, "error deserializing response: " + e.getMessage());
                                callback.onCallback(Radar.RadarStatus.ERROR_SERVER, null, null, null);
                                _RadarClient.this.mSending = false;
                            }
                        }
                    }
                }, new Response.ErrorListener(){

                    public void onErrorResponse(VolleyError error) {
                        if (error instanceof NetworkError || error instanceof TimeoutError) {
                            callback.onCallback(Radar.RadarStatus.ERROR_NETWORK, null, null, null);
                            _RadarClient.this.mSending = false;
                        } else if (error.networkResponse != null) {
                            if (error.networkResponse.statusCode == 400) {
                                callback.onCallback(Radar.RadarStatus.ERROR_LOCATION, null, null, null);
                                _RadarClient.this.mSending = false;
                            } else if (error.networkResponse.statusCode == 401) {
                                callback.onCallback(Radar.RadarStatus.ERROR_UNAUTHORIZED, null, null, null);
                                _RadarClient.this.mSending = false;
                            } else if (error.networkResponse.statusCode == 429) {
                                callback.onCallback(Radar.RadarStatus.ERROR_RATE_LIMIT, null, null, null);
                                _RadarClient.this.mSending = false;
                            } else if (error.networkResponse.statusCode == 500) {
                                callback.onCallback(Radar.RadarStatus.ERROR_SERVER, null, null, null);
                                _RadarClient.this.mSending = false;
                            }
                        } else {
                            callback.onCallback(Radar.RadarStatus.ERROR_UNKNOWN, null, null, null);
                            _RadarClient.this.mSending = false;
                        }
                    }
                });
                locationRequest.setHeader("Authorization", publishableKey);
                locationRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 0, 1.0f));
                _RadarClient.this.mRequestQueue.add((Request)locationRequest);
            }
        });
    }

    private void getFacebookPlacesForLocation(final Context context, Location location, boolean stopped, final _RadarFacebookPlacesCallback callback) {
        Radar.RadarPlacesProvider provider = _RadarSettings.getPlacesProvider(context);
        if (provider != Radar.RadarPlacesProvider.FACEBOOK) {
            callback.onCallback(false, null);
            return;
        }
        String facebookAccessToken = _RadarUtils.getFacebookAccessToken();
        if (facebookAccessToken == null) {
            callback.onCallback(true, null);
            return;
        }
        VolleyLog.DEBUG = _RadarSettings.isDebug(context);
        if (this.mRequestQueue == null) {
            this.mRequestQueue = Volley.newRequestQueue((Context)context);
        }
        String host = "https://graph.facebook.com";
        String facebookPlacesURL = host + "/v2.9/current_place/results?coordinates={\"latitude\":" + location.getLatitude() + ",\"longitude\":" + location.getLongitude() + ",\"accuracy\":" + location.getAccuracy() + "}&summary=tracking&limit=10&fields=confidence_level,category_list,website,name,single_line_address,location,checkins&access_token=" + facebookAccessToken;
        JsonObjectRequest facebookPlacesRequest = new JsonObjectRequest(0, facebookPlacesURL, null, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                if (response != null) {
                    String facebookPlaces = response.toString();
                    _RadarLogger.log(context, facebookPlaces);
                    callback.onCallback(false, facebookPlaces);
                } else {
                    _RadarLogger.log(context, "error getting Facebook places: no response");
                    callback.onCallback(false, null);
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                _RadarLogger.log(context, "error getting Facebook places: " + error.getMessage());
                callback.onCallback(false, null);
            }
        });
        facebookPlacesRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 0, 1.0f));
        this.mRequestQueue.add((Request)facebookPlacesRequest);
    }

    void verifyEvent(final Context context, String eventId, RadarEvent.RadarEventVerification verification, String verifiedPlaceId) {
        String verificationParam;
        String publishableKey = _RadarSettings.getPublishableKey(context);
        if (publishableKey == null || publishableKey.length() == 0) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        switch (verification) {
            case ACCEPT: {
                verificationParam = "1";
                break;
            }
            case REJECT: {
                verificationParam = "-1";
                break;
            }
            default: {
                verificationParam = "0";
            }
        }
        params.put("verification", verificationParam);
        if (verifiedPlaceId != null) {
            params.put("verifiedPlaceId", verifiedPlaceId);
        }
        VolleyLog.DEBUG = _RadarSettings.isDebug(context);
        if (this.mRequestQueue == null) {
            this.mRequestQueue = Volley.newRequestQueue((Context)context);
        }
        String host = _RadarSettings.getHost(context);
        String locationURL = host + "/v1/events/" + eventId + "/verification";
        _CustomJsonObjectRequest verifyRequest = new _CustomJsonObjectRequest(2, locationURL, new JSONObject(params), new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                _RadarLogger.log(context, "error verifying event: " + error.getMessage());
            }
        });
        verifyRequest.setHeader("Authorization", publishableKey);
        verifyRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 0, 1.0f));
        this.mRequestQueue.add((Request)verifyRequest);
    }

    abstract class _RadarFacebookPlacesCallback {
        _RadarFacebookPlacesCallback() {
        }

        abstract void onCallback(boolean var1, String var2);
    }
}

