/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.support.annotation.NonNull;
import com.onradar.sdk.Radar;
import com.onradar.sdk.model.RadarEvent;
import com.onradar.sdk.model.RadarUser;
import java.text.ParseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class RadarReceiver
extends BroadcastReceiver {
    public static final String RECEIVED = "com.onradar.sdk.RECEIVED";

    public void onReceive(Context context, Intent intent) {
        if (intent != null && intent.getAction().equals(RECEIVED)) {
            String response = intent.getStringExtra("response");
            Location location = (Location)intent.getExtras().getParcelable("location");
            if (response != null && location != null) {
                try {
                    JSONObject responseObj = new JSONObject(response);
                    JSONArray eventsArr = responseObj.getJSONArray("events");
                    int numEvents = eventsArr.length();
                    RadarEvent[] events = new RadarEvent[numEvents];
                    for (int i = 0; i < numEvents; ++i) {
                        RadarEvent event;
                        JSONObject eventObj = eventsArr.getJSONObject(i);
                        events[i] = event = new RadarEvent(eventObj);
                    }
                    JSONObject userObj = responseObj.getJSONObject("user");
                    RadarUser user = new RadarUser(userObj);
                    if (events.length > 0) {
                        this.onEventsReceived(context, events, user);
                    }
                    this.onLocationUpdated(context, location, user);
                }
                catch (ParseException | JSONException e) {
                    this.onError(context, Radar.RadarStatus.ERROR_UNKNOWN);
                }
            } else {
                Radar.RadarStatus status = Radar.RadarStatus.fromOrdinal(intent.getIntExtra("status", -1));
                if (status != Radar.RadarStatus.SUCCESS && status != Radar.RadarStatus.UNKNOWN) {
                    this.onError(context, status);
                }
            }
        }
    }

    public abstract void onEventsReceived(@NonNull Context var1, @NonNull RadarEvent[] var2, @NonNull RadarUser var3);

    public void onLocationUpdated(@NonNull Context context, @NonNull Location location, @NonNull RadarUser user) {
    }

    public abstract void onError(@NonNull Context var1, @NonNull Radar.RadarStatus var2);
}

