/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk.model;

import android.location.Location;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class RadarUserInsightsLocation {
    private RadarUserInsightsLocationType a;
    private Location b;
    private RadarUserInsightsLocationConfidence c;
    private Date d;

    public RadarUserInsightsLocation(RadarUserInsightsLocationType type, Location location, RadarUserInsightsLocationConfidence confidence, Date updatedAt) {
        this.a = type;
        this.b = location;
        this.c = confidence;
        this.d = updatedAt;
    }

    public RadarUserInsightsLocation(JSONObject obj) throws JSONException, ParseException {
        Object object;
        String string;
        if (obj == null) {
            return;
        }
        if (obj.has("type") && !obj.isNull("type")) {
            string = obj.getString("type");
            this.a = string.equals("home") ? RadarUserInsightsLocationType.HOME : (string.equals("office") ? RadarUserInsightsLocationType.OFFICE : RadarUserInsightsLocationType.UNKNOWN);
        }
        if (obj.has("location") && !obj.isNull("location") && (string = obj.getJSONObject("location")).has("coordinates")) {
            object = string.getJSONArray("coordinates");
            double d2 = object.getDouble(0);
            double d3 = object.getDouble(1);
            Location location = new Location("");
            location.setLongitude(d2);
            location.setLatitude(d3);
            this.b = location;
        }
        if (obj.has("confidence") && !obj.isNull("confidence")) {
            int n = obj.getInt("confidence");
            this.c = n == 3 ? RadarUserInsightsLocationConfidence.HIGH : (n == 2 ? RadarUserInsightsLocationConfidence.MEDIUM : (n == 1 ? RadarUserInsightsLocationConfidence.LOW : RadarUserInsightsLocationConfidence.NONE));
        }
        if (obj.has("updatedAt") && !obj.isNull("updatedAt")) {
            String string2 = obj.getString("updatedAt");
            object = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("UTC"));
            this.d = ((DateFormat)object).parse(string2);
        }
    }

    public RadarUserInsightsLocationType getType() {
        return this.a;
    }

    public Location getLocation() {
        return this.b;
    }

    public RadarUserInsightsLocationConfidence getConfidence() {
        return this.c;
    }

    public Date getUpdatedAt() {
        return this.d;
    }

    public static enum RadarUserInsightsLocationConfidence {
        NONE,
        LOW,
        MEDIUM,
        HIGH;

    }

    public static enum RadarUserInsightsLocationType {
        UNKNOWN,
        HOME,
        OFFICE;

    }
}

