/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk.model;

import com.onradar.sdk.model.RadarUserInsightsLocation;
import com.onradar.sdk.model.RadarUserInsightsState;
import java.text.ParseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RadarUserInsights {
    private RadarUserInsightsLocation a;
    private RadarUserInsightsLocation b;
    private RadarUserInsightsState c;

    public RadarUserInsights(RadarUserInsightsLocation homeLocation, RadarUserInsightsLocation officeLocation, RadarUserInsightsState state) {
        this.a = homeLocation;
        this.b = officeLocation;
        this.c = state;
    }

    public RadarUserInsights(JSONObject obj) throws JSONException, ParseException {
        if (obj == null) {
            return;
        }
        if (obj.has("locations") && !obj.isNull("locations")) {
            JSONArray jSONArray = obj.getJSONArray("locations");
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                RadarUserInsightsLocation radarUserInsightsLocation = new RadarUserInsightsLocation(jSONObject);
                if (radarUserInsightsLocation.getType() == RadarUserInsightsLocation.RadarUserInsightsLocationType.HOME) {
                    this.a = radarUserInsightsLocation;
                    continue;
                }
                if (radarUserInsightsLocation.getType() != RadarUserInsightsLocation.RadarUserInsightsLocationType.OFFICE) continue;
                this.b = radarUserInsightsLocation;
            }
        }
        if (obj.has("state") && !obj.isNull("state")) {
            this.c = new RadarUserInsightsState(obj.getJSONObject("state"));
        }
    }

    public RadarUserInsightsLocation getHomeLocation() {
        return this.a;
    }

    public RadarUserInsightsLocation getOfficeLocation() {
        return this.b;
    }

    public RadarUserInsightsState getState() {
        return this.c;
    }
}

