/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk.model;

import com.onradar.sdk.model.RadarGeofence;
import com.onradar.sdk.model.RadarPlace;
import com.onradar.sdk.model.RadarUserInsights;
import java.text.ParseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RadarUser {
    private String a;
    private String b;
    private String c;
    private RadarGeofence[] d;
    private RadarPlace e;
    private RadarUserInsights f;

    public RadarUser(String _id, String userId, String description, RadarGeofence[] geofences, RadarPlace place, RadarUserInsights insights) {
        this.a = _id;
        this.b = userId;
        this.c = description;
        this.d = geofences;
        this.e = place;
        this.f = insights;
    }

    public RadarUser(JSONObject obj) throws JSONException, ParseException {
        if (obj == null) {
            return;
        }
        if (obj.has("_id") && !obj.isNull("_id")) {
            this.a = obj.getString("_id");
        }
        if (obj.has("userId") && !obj.isNull("userId")) {
            this.b = obj.getString("userId");
        }
        if (obj.has("description") && !obj.isNull("description")) {
            this.c = obj.getString("description");
        }
        if (obj.has("geofences") && !obj.isNull("geofences")) {
            JSONArray jSONArray = obj.getJSONArray("geofences");
            int n = jSONArray.length();
            this.d = new RadarGeofence[n];
            for (int i = 0; i < n; ++i) {
                RadarGeofence radarGeofence;
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                this.d[i] = radarGeofence = new RadarGeofence(jSONObject);
            }
        }
        if (obj.has("place") && !obj.isNull("place")) {
            this.e = new RadarPlace(obj.getJSONObject("place"));
        }
        if (obj.has("insights") && !obj.isNull("insights")) {
            this.f = new RadarUserInsights(obj.getJSONObject("insights"));
        }
    }

    public String getId() {
        return this.a;
    }

    public String getUserId() {
        return this.b;
    }

    public String getDescription() {
        return this.c;
    }

    public RadarGeofence[] getGeofences() {
        return this.d;
    }

    public RadarPlace getPlace() {
        return this.e;
    }

    public RadarUserInsights getInsights() {
        return this.f;
    }
}

