/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk.model;

import com.onradar.sdk.model.RadarGeofence;
import com.onradar.sdk.model.RadarPlace;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RadarEvent {
    private String a;
    private Date b;
    private boolean c;
    private RadarEventType d;
    private RadarGeofence e;
    private RadarPlace f;
    private RadarEventConfidence g;
    private float h;

    public static RadarEvent[] eventsFromJSONArray(JSONArray array) throws JSONException, ParseException {
        int n = array.length();
        RadarEvent[] radarEventArray = new RadarEvent[n];
        for (int i = 0; i < n; ++i) {
            RadarEvent radarEvent;
            JSONObject jSONObject = array.getJSONObject(i);
            radarEventArray[i] = radarEvent = new RadarEvent(jSONObject);
        }
        return radarEventArray;
    }

    public RadarEvent(String _id, Date createdAt, boolean live, RadarEventType type, RadarGeofence geofence, RadarPlace place, RadarEventConfidence confidence, float duration) {
        this.a = _id;
        this.b = createdAt;
        this.c = live;
        this.d = type;
        this.e = geofence;
        this.f = place;
        this.g = confidence;
        this.h = duration;
    }

    public RadarEvent(JSONObject obj) throws JSONException, ParseException {
        String string;
        if (obj == null) {
            return;
        }
        if (obj.has("_id") && !obj.isNull("_id")) {
            this.a = obj.getString("_id");
        }
        if (obj.has("createdAt") && !obj.isNull("createdAt")) {
            string = obj.getString("createdAt");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.b = simpleDateFormat.parse(string);
        }
        if (obj.has("live") && !obj.isNull("live")) {
            this.c = obj.getBoolean("live");
        }
        if (obj.has("type") && !obj.isNull("type")) {
            string = obj.getString("type");
            this.d = string.equals("user.entered_geofence") ? RadarEventType.USER_ENTERED_GEOFENCE : (string.equals("user.exited_geofence") ? RadarEventType.USER_EXITED_GEOFENCE : (string.equals("user.entered_home") ? RadarEventType.USER_ENTERED_HOME : (string.equals("user.exited_home") ? RadarEventType.USER_EXITED_HOME : (string.equals("user.entered_office") ? RadarEventType.USER_ENTERED_OFFICE : (string.equals("user.exited_office") ? RadarEventType.USER_EXITED_OFFICE : (string.equals("user.started_traveling") ? RadarEventType.USER_STARTED_TRAVELING : (string.equals("user.stopped_traveling") ? RadarEventType.USER_STOPPED_TRAVELING : (string.equals("user.entered_place") ? RadarEventType.USER_ENTERED_PLACE : (string.equals("user.exited_place") ? RadarEventType.USER_EXITED_PLACE : RadarEventType.UNKNOWN)))))))));
        }
        if (obj.has("geofence") && !obj.isNull("geofence")) {
            string = obj.getJSONObject("geofence");
            this.e = new RadarGeofence((JSONObject)string);
        }
        if (obj.has("place") && !obj.isNull("place")) {
            string = obj.getJSONObject("place");
            this.f = new RadarPlace((JSONObject)string);
        }
        if (obj.has("confidence") && !obj.isNull("confidence")) {
            int n = obj.getInt("confidence");
            this.g = n == 3 ? RadarEventConfidence.HIGH : (n == 2 ? RadarEventConfidence.MEDIUM : (n == 1 ? RadarEventConfidence.LOW : RadarEventConfidence.NONE));
        }
        if (obj.has("duration") && !obj.isNull("duration")) {
            this.h = (float)obj.getDouble("duration");
        }
    }

    public String getId() {
        return this.a;
    }

    public Date getCreatedAt() {
        return this.b;
    }

    public boolean getLive() {
        return this.c;
    }

    public RadarEventType getType() {
        return this.d;
    }

    public RadarGeofence getGeofence() {
        return this.e;
    }

    public RadarPlace getPlace() {
        return this.f;
    }

    public RadarEventConfidence getConfidence() {
        return this.g;
    }

    public float getDuration() {
        return this.h;
    }

    public static enum RadarEventVerification {
        ACCEPT,
        UNVERIFY,
        REJECT;

    }

    public static enum RadarEventConfidence {
        NONE,
        LOW,
        MEDIUM,
        HIGH;

    }

    public static enum RadarEventType {
        UNKNOWN,
        USER_ENTERED_GEOFENCE,
        USER_EXITED_GEOFENCE,
        USER_ENTERED_HOME,
        USER_EXITED_HOME,
        USER_ENTERED_OFFICE,
        USER_EXITED_OFFICE,
        USER_STARTED_TRAVELING,
        USER_STOPPED_TRAVELING,
        USER_ENTERED_PLACE,
        USER_EXITED_PLACE;

    }
}

