/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.onradar.sdk.Radar;
import com.onradar.sdk.model.RadarEvent;
import com.onradar.sdk.model.RadarUser;
import java.text.ParseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class RadarReceiver
extends BroadcastReceiver {
    public static final String RECEIVED = "com.onradar.sdk.RECEIVED";

    public void onReceive(Context context, Intent intent) {
        if (intent != null && intent.getAction().equals(RECEIVED)) {
            String string = intent.getStringExtra("response");
            if (string != null) {
                try {
                    Object object;
                    JSONObject jSONObject = new JSONObject(string);
                    JSONArray jSONArray = jSONObject.getJSONArray("events");
                    int n = jSONArray.length();
                    RadarEvent[] radarEventArray = new RadarEvent[n];
                    for (int i = 0; i < n; ++i) {
                        RadarEvent radarEvent;
                        object = jSONArray.getJSONObject(i);
                        radarEventArray[i] = radarEvent = new RadarEvent((JSONObject)object);
                    }
                    JSONObject jSONObject2 = jSONObject.getJSONObject("user");
                    object = new RadarUser(jSONObject2);
                    if (radarEventArray.length > 0) {
                        this.onEventsReceived(context, radarEventArray, (RadarUser)object);
                    }
                }
                catch (ParseException | JSONException throwable) {
                    this.onError(context, Radar.RadarStatus.ERROR_UNKNOWN);
                }
            } else {
                Radar.RadarStatus radarStatus = Radar.RadarStatus.fromOrdinal(intent.getIntExtra("status", -1));
                if (radarStatus != Radar.RadarStatus.SUCCESS && radarStatus != Radar.RadarStatus.UNKNOWN) {
                    this.onError(context, radarStatus);
                }
            }
        }
    }

    public abstract void onEventsReceived(@NonNull Context var1, @NonNull RadarEvent[] var2, @NonNull RadarUser var3);

    public abstract void onError(@NonNull Context var1, @NonNull Radar.RadarStatus var2);
}

