package com.onradar.sdk.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;

public class RadarUser {

    private String mId;
    private String mUserId;
    private String mDescription;
    private RadarGeofence[] mGeofences;
    private RadarPlace mPlace;
    private RadarUserInsights mInsights;

    public RadarUser(String _id, String userId, String description, RadarGeofence[] geofences, RadarPlace place, RadarUserInsights insights) {
        mId = _id;
        mUserId = userId;
        mDescription = description;
        mGeofences = geofences;
        mPlace = place;
        mInsights = insights;
    }

    public RadarUser(JSONObject obj) throws JSONException, ParseException {
        if (obj == null)
            return;

        if (obj.has("_id") && !obj.isNull("_id"))
            mId = obj.getString("_id");

        if (obj.has("userId") && !obj.isNull("userId"))
            mUserId = obj.getString("userId");

        if (obj.has("description") && !obj.isNull("description"))
            mDescription = obj.getString("description");

        if (obj.has("geofences") && !obj.isNull("geofences")) {
            JSONArray geofencesArr = obj.getJSONArray("geofences");
            int numGeofences = geofencesArr.length();

            mGeofences = new RadarGeofence[numGeofences];

            for (int i = 0; i < numGeofences; i++) {
                JSONObject geofenceObj = geofencesArr.getJSONObject(i);
                RadarGeofence geofence = new RadarGeofence(geofenceObj);
                mGeofences[i] = geofence;
            }
        }

        if (obj.has("place") && !obj.isNull("place")) {
            mPlace = new RadarPlace((obj.getJSONObject("place")));
        }

        if (obj.has("insights") && !obj.isNull("insights")) {
            mInsights = new RadarUserInsights(obj.getJSONObject("insights"));
        }
    }

    /**
     * @return The unique ID for the user, provided by Radar.
     */
    public String getId() {
        return mId;
    }

    /**
     * @return The unique ID for the user, provided when you identified the user.
     */
    public String getUserId() {
        return mUserId;
    }

    /**
     * @return An optional description for the user, provided when you started tracking the user.
     */
    public String getDescription() {
        return mDescription;
    }

    /**
     * @return An array of the user's last known geofences. May be null or empty if the user is not in any geofences.
     */
    public RadarGeofence[] getGeofences() {
        return mGeofences;
    }

    /**
     * @return The user's last known place.  May be null if the user is not at a place, or if Places is turned off.
     */
    public RadarPlace getPlace() {
        return mPlace;
    }

    /**
     * @return Learned insights for the user. May be null if no insights are available, or if Insights is turned off.
     */
    public RadarUserInsights getInsights() {
        return mInsights;
    }

}